/*
 * Decompiled with CFR 0.152.
 */
package jabref.imports;

import jabref.BasePanel;
import jabref.BibtexEntry;
import jabref.GUIGlobals;
import jabref.Globals;
import jabref.KeyCollisionException;
import jabref.SidePaneComponent;
import jabref.SidePaneHeader;
import jabref.SidePaneManager;
import jabref.Util;
import jabref.imports.AuthorDialog;
import jabref.imports.MedlineHandler;
import jabref.undo.NamedCompound;
import jabref.undo.UndoableInsertEntry;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class MedlineFetcher
extends SidePaneComponent
implements Runnable {
    final int MAX_TO_FETCH = 10;
    SidePaneHeader header = new SidePaneHeader("Fetch Medline", GUIGlobals.fetchMedlineIcon, this);
    BasePanel panel;
    JTextField tf = new JTextField();
    JPanel pan = new JPanel();
    GridBagLayout gbl = new GridBagLayout();
    GridBagConstraints con = new GridBagConstraints();
    JButton ok = new JButton(new ImageIcon(GUIGlobals.fetchMedlineIcon));
    MedlineFetcher ths = this;
    AuthorDialog authorDialog;
    JFrame jFrame;

    public MedlineFetcher(BasePanel panel_, SidePaneManager p0) {
        super(p0);
        this.panel = panel_;
        this.tf.setMinimumSize(new Dimension(1, 1));
        this.setLayout(this.gbl);
        this.con.fill = 1;
        this.con.insets = new Insets(0, 0, 2, 0);
        this.con.gridwidth = 0;
        this.con.weightx = 1.0;
        this.con.weighty = 1.0;
        this.gbl.setConstraints(this.header, this.con);
        this.add(this.header);
        this.con.gridwidth = 1;
        this.con.insets = new Insets(0, 0, 0, 0);
        this.con.fill = 2;
        this.gbl.setConstraints(this.tf, this.con);
        this.add(this.tf);
        this.con.weightx = 0.0;
        this.gbl.setConstraints(this.ok, this.con);
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new Thread(MedlineFetcher.this.ths).start();
            }
        };
        this.ok.addActionListener(listener);
        this.tf.addActionListener(listener);
    }

    public void fetchById() {
        String idList = this.tf.getText().replace(';', ',');
        Pattern p = Pattern.compile("\\d+[,\\d+]*");
        Matcher m = p.matcher(idList);
        if (m.matches()) {
            this.panel.frame().output(Globals.lang("Fetching Medline by ID..."));
            ArrayList bibs = this.fetchMedline(idList);
            if (bibs != null && bibs.size() > 0) {
                if (this.panel.prefs().getBoolean("useOwner")) {
                    Util.setDefaultOwner(bibs, this.panel.prefs().get("defaultOwner"));
                }
                this.tf.setText("");
                NamedCompound ce = new NamedCompound("fetch Medline");
                Iterator i = bibs.iterator();
                while (i.hasNext()) {
                    try {
                        BibtexEntry be = (BibtexEntry)i.next();
                        String id = Util.createId(be.getType(), this.panel.database());
                        be.setId(id);
                        this.panel.database().insertEntry(be);
                        ce.addEdit(new UndoableInsertEntry(this.panel.database(), be, this.panel));
                    }
                    catch (KeyCollisionException keyCollisionException) {}
                }
                ce.end();
                this.panel.output(Globals.lang("Medline entries fetched") + ": " + bibs.size());
                this.panel.undoManager.addEdit(ce);
                this.panel.markBaseChanged();
                this.panel.refreshTable();
            } else {
                this.panel.output(Globals.lang("No Medline entries found."));
            }
        } else {
            JOptionPane.showMessageDialog(this.panel.frame(), Globals.lang("Please enter a semicolon or comma separated list of Medline IDs (numbers)."), Globals.lang("Input error"), 0);
        }
    }

    public ArrayList fetchMedline(String id) {
        ArrayList bibItems = null;
        try {
            String baseUrl = "http://eutils.ncbi.nlm.nih.gov/entrez/eutils/efetch.fcgi?db=pubmed&retmode=xml&rettype=citation&id=" + id;
            URL url = new URL(baseUrl);
            HttpURLConnection data = (HttpURLConnection)url.openConnection();
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            parserFactory.setValidating(true);
            parserFactory.setNamespaceAware(true);
            SAXParser parser = parserFactory.newSAXParser();
            MedlineHandler handler = new MedlineHandler();
            parser.parse(data.getInputStream(), (DefaultHandler)handler);
            bibItems = handler.getItems();
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bibItems;
    }

    @Override
    public void run() {
        String idList = this.tf.getText().replace(';', ',');
        Pattern p1 = Pattern.compile("\\d+[,\\d+]*");
        Pattern p2 = Pattern.compile(".+[,.+]*");
        Matcher m1 = p1.matcher(idList);
        Matcher m2 = p2.matcher(idList);
        if (m1.matches()) {
            this.fetchById();
        } else {
            JOptionPane.showMessageDialog(this.panel.frame(), Globals.lang("Please enter a semicolon or comma separated list of Medline IDs (numbers)."), Globals.lang("Input error"), 0);
        }
    }

    public String setupTerm(String in) {
        Pattern part1 = Pattern.compile(", ");
        Pattern part2 = Pattern.compile(",");
        Pattern part3 = Pattern.compile(" ");
        Matcher matcher = part1.matcher(in);
        in = matcher.replaceAll("\\+AND\\+");
        matcher = part2.matcher(in);
        in = matcher.replaceAll("\\+AND\\+");
        matcher = part3.matcher(in);
        in = matcher.replaceAll("+");
        return in;
    }

    public String[] getIds(String term) {
        String baseUrl = "http://eutils.ncbi.nlm.nih.gov/entrez/eutils";
        String medlineUrl = baseUrl + "/esearch.fcgi?retmax=20&usehistory=y&db=pubmed&term=";
        Pattern idPattern = Pattern.compile("<Id>(\\d+)</Id>");
        Pattern countPattern = Pattern.compile("<Count>(\\d+)<\\/Count>");
        boolean doCount = true;
        int count = 0;
        String[] id = new String[10];
        try {
            String inLine;
            URL ncbi = new URL(medlineUrl + term);
            HttpURLConnection ncbiCon = (HttpURLConnection)ncbi.openConnection();
            BufferedReader in = new BufferedReader(new InputStreamReader(ncbi.openStream()));
            while ((inLine = in.readLine()) != null) {
                Matcher matcher;
                if (doCount) {
                    matcher = countPattern.matcher(inLine);
                    if (!matcher.find()) continue;
                    count = Integer.parseInt(matcher.group(1));
                    id = new String[count];
                    count = 0;
                    doCount = false;
                    continue;
                }
                matcher = idPattern.matcher(inLine);
                if (!matcher.find()) continue;
                id[count++] = matcher.group(1);
            }
        }
        catch (MalformedURLException e) {
            System.out.println("bad url");
            e.printStackTrace();
        }
        catch (IOException e) {
            System.out.println("connection failed");
            e.printStackTrace();
        }
        return id;
    }

    public String[] getTitles(String[] idArrayList) {
        String[] titles = new String[Math.min(10, idArrayList.length)];
        for (int i = 0; i < Math.min(10, idArrayList.length); ++i) {
            String temp = this.getOneCitation(idArrayList[i]);
            titles[i] = this.getVitalData(temp);
        }
        return titles;
    }

    public String getOneCitation(String id) {
        String baseUrl = "http://eutils.ncbi.nlm.nih.gov/entrez/eutils";
        String retrieveUrl = baseUrl + "/efetch.fcgi?db=pubmed&retmode=xml&rettype=citation&id=";
        StringBuffer sb = new StringBuffer();
        try {
            String inLine;
            URL ncbi = new URL(retrieveUrl + id);
            HttpURLConnection ncbiCon = (HttpURLConnection)ncbi.openConnection();
            BufferedReader in = new BufferedReader(new InputStreamReader(ncbi.openStream()));
            while ((inLine = in.readLine()) != null) {
                sb.append(inLine);
            }
        }
        catch (MalformedURLException e) {
            System.out.println("bad url");
            e.printStackTrace();
        }
        catch (IOException e) {
            System.out.println("connection failed");
            e.printStackTrace();
        }
        return sb.toString();
    }

    public String getVitalData(String sb) {
        StringBuffer result = new StringBuffer();
        Pattern articleTitle = Pattern.compile("<ArticleTitle>(.+)</ArticleTitle>");
        Pattern authorName = Pattern.compile("<Author>(.+)</Author>");
        Matcher matcher = articleTitle.matcher(sb);
        if (matcher.find()) {
            result.append("Title: " + matcher.group(1));
        }
        return result.toString();
    }
}

