/*
 * Decompiled with CFR 0.152.
 */
package jabref.groups;

import jabref.groups.GroupSelector;
import java.util.Vector;
import javax.swing.undo.AbstractUndoableEdit;

class UndoableModifyGroup
extends AbstractUndoableEdit {
    private Vector groups;
    private int index;
    private String name;
    private String regexp;
    private String field;
    private String oldName;
    private String oldRegexp;
    private String oldField;
    private GroupSelector gs;

    public UndoableModifyGroup(GroupSelector gs, Vector groups, int index, String field, String name, String regexp, String oldField, String oldName, String oldRegexp) {
        this.gs = gs;
        this.groups = groups;
        this.index = index;
        this.name = name;
        this.regexp = regexp;
        this.field = field;
        this.oldName = oldName;
        this.oldRegexp = oldRegexp;
        this.oldField = oldField;
    }

    @Override
    public String getUndoPresentationName() {
        return "Undo: modify group";
    }

    @Override
    public String getRedoPresentationName() {
        return "Redo: modify group";
    }

    @Override
    public void undo() {
        super.undo();
        this.remove();
        this.insert(this.oldRegexp, this.oldName, this.oldField);
    }

    @Override
    public void redo() {
        super.redo();
        this.remove();
        this.insert(this.regexp, this.name, this.field);
    }

    private void remove() {
        for (int i = 0; i < 3; ++i) {
            this.groups.removeElementAt(this.index);
        }
    }

    private void insert(String one, String two, String three) {
        this.index = GroupSelector.findPos(this.groups, two);
        this.groups.add(this.index, one);
        this.groups.add(this.index, two);
        this.groups.add(this.index, three);
        this.gs.revalidateList();
    }
}

