/*
 * Decompiled with CFR 0.152.
 */
package jabref.groups;

import jabref.BasePanel;
import jabref.DatabaseSearch;
import jabref.GUIGlobals;
import jabref.Globals;
import jabref.HelpAction;
import jabref.JabRefFrame;
import jabref.JabRefPreferences;
import jabref.SidePaneComponent;
import jabref.SidePaneHeader;
import jabref.SidePaneManager;
import jabref.groups.AndOrSearchRuleSet;
import jabref.groups.AutoGroupDialog;
import jabref.groups.GroupDialog;
import jabref.groups.QuickSearchRule;
import jabref.groups.UndoableAddOrRemoveGroup;
import jabref.groups.UndoableModifyGroup;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.undo.CompoundEdit;

public class GroupSelector
extends SidePaneComponent
implements ListSelectionListener,
ActionListener {
    public static final int DIM = 3;
    public static final int OFFSET = 0;
    JButton newButton = new JButton(new ImageIcon(GUIGlobals.newSmallIconFile));
    JButton helpButton = new JButton(new ImageIcon(GUIGlobals.helpSmallIconFile));
    JButton refresh = new JButton(new ImageIcon(GUIGlobals.refreshSmallIconFile));
    JButton autoGroup = new JButton(new ImageIcon(GUIGlobals.autoGroupIcon));
    Color bgColor = Color.white;
    JList list;
    ListModel listModel;
    JScrollPane sp;
    GridBagLayout gbl = new GridBagLayout();
    GridBagConstraints con = new GridBagConstraints();
    Vector groups;
    JabRefFrame frame;
    BasePanel panel;
    String searchField;
    JPopupMenu gropt = new JPopupMenu();
    JCheckBox andCb = new JCheckBox(Globals.lang("Intersection"), true);
    JCheckBox orCb = new JCheckBox(Globals.lang("Union"), false);
    JCheckBox invCb = new JCheckBox(Globals.lang("Inverted"), false);
    ButtonGroup bgr = new ButtonGroup();
    SidePaneManager manager;
    JabRefPreferences prefs;
    GroupSelector ths;
    AbstractAction modifyAction = new AbstractAction(Globals.lang("Modify")){

        @Override
        public void actionPerformed(ActionEvent e) {
            int index = 0 + 3 * (GroupSelector.this.list.getSelectedIndex() - 1);
            int groupIndex = GroupSelector.this.list.getSelectedIndex();
            GroupDialog gd = new GroupDialog(GroupSelector.this.frame, GroupSelector.this.groups, index, GroupSelector.this.prefs.get("groupsDefaultField"));
            gd.setVisible(true);
            if (gd.okPressed()) {
                GroupSelector.this.revalidateList((gd.index() - 0) / 3 + 1);
                GroupSelector.this.panel.undoManager.addEdit(new UndoableModifyGroup(GroupSelector.this.ths, GroupSelector.this.groups, gd.index(), gd.field(), gd.name(), gd.regexp(), gd.oldField(), gd.oldName(), gd.oldRegexp()));
                GroupSelector.this.panel.markBaseChanged();
                GroupSelector.this.frame.output(Globals.lang("Modified group") + " '" + gd.name() + "'.");
            }
        }
    };

    public GroupSelector(JabRefFrame frame, BasePanel panel, Vector groupData, SidePaneManager manager, JabRefPreferences prefs2) {
        super(manager);
        this.ths = this;
        this.prefs = prefs2;
        this.groups = groupData;
        this.manager = manager;
        this.frame = frame;
        this.panel = panel;
        double n = this.groups.size() - 0;
        while (n > 0.0 && n / 3.0 != Math.floor(n / 3.0)) {
            this.groups.removeElementAt(this.groups.size() - 1);
            n = this.groups.size() - 0;
        }
        Dimension butDim = new Dimension(20, 20);
        this.newButton.setPreferredSize(butDim);
        this.newButton.setMinimumSize(butDim);
        this.refresh.setPreferredSize(butDim);
        this.refresh.setMinimumSize(butDim);
        this.helpButton.setPreferredSize(butDim);
        this.helpButton.setMinimumSize(butDim);
        this.autoGroup.setPreferredSize(butDim);
        this.autoGroup.setMinimumSize(butDim);
        this.newButton.addActionListener(this);
        this.refresh.addActionListener(this);
        this.andCb.addActionListener(this);
        this.orCb.addActionListener(this);
        this.invCb.addActionListener(this);
        this.autoGroup.addActionListener(this);
        this.newButton.setToolTipText(Globals.lang("New group"));
        this.refresh.setToolTipText(Globals.lang("Refresh view"));
        this.andCb.setToolTipText(Globals.lang("Display only entries belonging to all selected groups."));
        this.orCb.setToolTipText(Globals.lang("Display all entries belonging to one or more of the selected groups."));
        this.autoGroup.setToolTipText(Globals.lang("Automatically create groups for database."));
        this.bgr.add(this.andCb);
        this.bgr.add(this.orCb);
        this.setLayout(this.gbl);
        SidePaneHeader header = new SidePaneHeader("Groups", GUIGlobals.groupsIconFile, this);
        this.con.gridwidth = 0;
        this.con.fill = 1;
        this.con.insets = new Insets(0, 0, 2, 0);
        this.gbl.setConstraints(header, this.con);
        this.add(header);
        this.con.gridwidth = 1;
        this.con.weightx = 1.0;
        this.con.insets = new Insets(0, 0, 0, 0);
        this.gbl.setConstraints(this.newButton, this.con);
        this.add(this.newButton);
        this.gbl.setConstraints(this.refresh, this.con);
        this.add(this.refresh);
        this.gbl.setConstraints(this.autoGroup, this.con);
        this.add(this.autoGroup);
        this.con.gridwidth = 0;
        HelpAction helpAction = new HelpAction(frame.helpDiag, GUIGlobals.groupsHelp, "Help on groups");
        this.helpButton.addActionListener(helpAction);
        this.helpButton.setToolTipText(Globals.lang("Help on groups"));
        this.gbl.setConstraints(this.helpButton, this.con);
        this.add(this.helpButton);
        this.list = new JList();
        this.revalidateList();
        this.list.addListSelectionListener(this);
        this.list.setPrototypeCellValue("Suitable length");
        this.list.setVisibleRowCount(10);
        this.list.setSelectionMode(2);
        this.sp = new JScrollPane(this.list, 20, 30);
        this.con.gridwidth = 0;
        this.con.weighty = 1.0;
        this.gbl.setConstraints(this.sp, this.con);
        this.add(this.sp);
        JPanel lower = new JPanel();
        lower.setLayout(this.gbl);
        lower.setBorder(BorderFactory.createEtchedBorder());
        this.con.weighty = 0.0;
        this.con.anchor = 17;
        this.gbl.setConstraints(this.andCb, this.con);
        lower.add(this.andCb);
        this.gbl.setConstraints(this.orCb, this.con);
        lower.add(this.orCb);
        this.gbl.setConstraints(this.invCb, this.con);
        lower.add(this.invCb);
        this.gbl.setConstraints(lower, this.con);
        this.add(lower);
        this.definePopup();
    }

    public void definePopup() {
        this.gropt.add(this.modifyAction);
        this.gropt.add(new AbstractAction(Globals.lang("Remove")){

            @Override
            public void actionPerformed(ActionEvent e) {
                String gname = (String)GroupSelector.this.groups.elementAt(0 + 3 * (GroupSelector.this.list.getSelectedIndex() - 1) + 1);
                int conf = JOptionPane.showConfirmDialog(GroupSelector.this.frame, Globals.lang("Remove group") + " '" + gname + "'?", Globals.lang("Remove group"), 0);
                if (conf == 0) {
                    try {
                        int index = 0 + 3 * (GroupSelector.this.list.getSelectedIndex() - 1);
                        String field = (String)GroupSelector.this.groups.elementAt(index);
                        String name = (String)GroupSelector.this.groups.elementAt(index + 1);
                        String regexp = (String)GroupSelector.this.groups.elementAt(index + 2);
                        for (int i = 0; i < 3; ++i) {
                            GroupSelector.this.groups.removeElementAt(index);
                        }
                        GroupSelector.this.revalidateList();
                        GroupSelector.this.panel.undoManager.addEdit(new UndoableAddOrRemoveGroup(GroupSelector.this.ths, GroupSelector.this.groups, index, false, field, name, regexp));
                        GroupSelector.this.panel.markBaseChanged();
                        GroupSelector.this.frame.output(Globals.lang("Removed group") + " '" + name + "'.");
                    }
                    catch (ArrayIndexOutOfBoundsException ex) {
                        System.err.println(Globals.lang("Unexpected error when trying to remove group."));
                    }
                }
            }
        });
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int index = GroupSelector.this.list.locationToIndex(e.getPoint());
                if (index == 0) {
                    GroupSelector.this.list.setSelectedIndex(0);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                int index = GroupSelector.this.list.locationToIndex(e.getPoint());
                if (e.getButton() == 3) {
                    if (index > 0 && index < GroupSelector.this.list.getModel().getSize()) {
                        GroupSelector.this.list.setSelectedIndex(index);
                        GroupSelector.this.gropt.show(GroupSelector.this.list, e.getPoint().x, GroupSelector.this.list.indexToLocation((int)index).y);
                    }
                } else if (index > 0 && e.getClickCount() == 2) {
                    GroupSelector.this.modifyAction.actionPerformed(new ActionEvent(GroupSelector.this.list, 0, "Modify"));
                }
            }
        });
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting() && !this.list.isSelectionEmpty()) {
            int[] sel = this.list.getSelectedIndices();
            if (sel.length == 1 && sel[0] == 0) {
                this.panel.stopShowingGroup();
                this.frame.output(Globals.lang("Displaying no groups") + ".");
            } else {
                AndOrSearchRuleSet searchRules = new AndOrSearchRuleSet(this.andCb.isSelected(), this.invCb.isSelected());
                for (int i = 0; i < sel.length; ++i) {
                    if (sel[i] <= 0) continue;
                    QuickSearchRule rule = new QuickSearchRule((String)this.groups.elementAt(sel[i] * 3 + 0 - 3), (String)this.groups.elementAt(sel[i] * 3 + 0 - 1));
                    searchRules.addRule(rule);
                }
                Hashtable<String, String> searchOptions = new Hashtable<String, String>();
                searchOptions.put("option", "dummy");
                DatabaseSearch search2 = new DatabaseSearch(searchOptions, searchRules, this.panel, "__groupsearch", true);
                search2.start();
                this.frame.output(Globals.lang("Updated group selection") + ".");
            }
        }
    }

    public void revalidateList() {
        this.revalidateList(0);
    }

    public void revalidateList(int sel) {
        Vector<String> newData = new Vector<String>();
        newData.add(Globals.lang("All entries"));
        for (int i = 1; i < this.groups.size(); i += 3) {
            newData.add((String)this.groups.elementAt(i));
        }
        this.list.clearSelection();
        this.list.setListData(newData);
        this.list.setSelectedIndex(sel);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        JDialog gd;
        if (e.getSource() == this.refresh) {
            this.valueChanged(new ListSelectionEvent(this.list, 1, 2, false));
        }
        if (e.getSource() == this.newButton) {
            gd = new GroupDialog(this.frame, this.groups, -1, this.prefs.get("groupsDefaultField"));
            gd.setVisible(true);
            if (((GroupDialog)gd).okPressed()) {
                this.revalidateList((((GroupDialog)gd).index() - 0) / 3 + 1);
                int index = ((GroupDialog)gd).index();
                this.panel.undoManager.addEdit(new UndoableAddOrRemoveGroup(this, this.groups, index, true, (String)this.groups.elementAt(index), (String)this.groups.elementAt(index + 1), (String)this.groups.elementAt(index + 2)));
                this.panel.markBaseChanged();
                this.frame.output(Globals.lang("Created group") + " '" + ((GroupDialog)gd).name() + "'.");
            }
        }
        if (e.getSource() == this.autoGroup) {
            gd = new AutoGroupDialog(this.frame, this.panel, this, this.groups, this.prefs.get("groupsDefaultField"), ".,");
            gd.setVisible(true);
            if (!((AutoGroupDialog)gd).okPressed()) return;
        }
        if (!(e.getSource() instanceof JCheckBox)) return;
        this.valueChanged(new ListSelectionEvent(this.list, 1, 2, false));
    }

    @Override
    public void componentOpening() {
        this.valueChanged(new ListSelectionEvent(this.list, this.list.getSelectedIndex(), this.list.getSelectedIndex(), false));
    }

    @Override
    public void componentClosing() {
        this.panel.stopShowingGroup();
    }

    public static int findPos(Vector groups, String name) {
        int index = -1;
        for (int i = 0; i < groups.size(); i += 3) {
            if (name.toLowerCase().compareTo(((String)groups.elementAt(i + 1)).toLowerCase()) >= 0) continue;
            index = i;
            i = groups.size();
        }
        if (index == -1) {
            index = groups.size();
        }
        return index;
    }

    public void addGroups(Vector newGroups, CompoundEdit ce) {
        double n = newGroups.size() - 0;
        while (n > 0.0 && n / 3.0 != Math.floor(n / 3.0)) {
            newGroups.removeElementAt(this.groups.size() - 1);
            n = this.groups.size() - 0;
        }
        for (int i = 0; i < (newGroups.size() - 0) / 3; ++i) {
            int pos = 0 + i * 3;
            int index = GroupSelector.findPos(this.groups, (String)newGroups.elementAt(pos + 1));
            String regexp = (String)newGroups.elementAt(pos + 2);
            String name = (String)newGroups.elementAt(pos + 1);
            String field = (String)newGroups.elementAt(pos);
            this.groups.add(index, regexp);
            this.groups.add(index, name);
            this.groups.add(index, field);
            ce.addEdit(new UndoableAddOrRemoveGroup(this, this.groups, index, true, field, name, regexp));
        }
    }
}

