/*
 * Decompiled with CFR 0.152.
 */
package jabref.groups;

import jabref.BibtexEntry;
import jabref.SearchRule;
import jabref.SearchRuleSet;
import java.util.Enumeration;
import java.util.Hashtable;

class AndOrSearchRuleSet
extends SearchRuleSet {
    private boolean and;
    private boolean invert;

    public AndOrSearchRuleSet(boolean and, boolean invert) {
        this.and = and;
        this.invert = invert;
    }

    @Override
    public int applyRules(Hashtable searchString, BibtexEntry bibtexEntry) {
        boolean res;
        int score = 0;
        Enumeration e = this.ruleSet.elements();
        while (e.hasMoreElements()) {
            score += ((SearchRule)e.nextElement()).applyRule(searchString, bibtexEntry) > 0 ? 1 : 0;
        }
        if (this.and) {
            res = score == this.ruleSet.size();
        } else {
            boolean bl = res = score > 0;
        }
        if (this.invert) {
            return res ? 0 : 1;
        }
        return res ? 1 : 0;
    }
}

