/*
 * Decompiled with CFR 0.152.
 */
package jabref.export.layout;

import jabref.BibtexEntry;
import jabref.export.layout.LayoutFormatter;
import jabref.wsi.ra.tool.WSITools;
import jabref.wsi.ra.types.StringInt;
import java.util.Vector;

public class LayoutEntry {
    private LayoutFormatter option;
    private String text;
    private LayoutEntry[] layoutEntries;
    private int type;

    public LayoutEntry(StringInt si) {
        this.type = si.i;
        if (si.i == 1) {
            this.text = si.s;
        } else if (si.i == 2) {
            this.text = si.s.trim();
        } else if (si.i != 3 && si.i != 4 && si.i == 5) {
            Vector v = new Vector();
            WSITools.tokenize(v, si.s, "\n");
            if (v.size() == 1) {
                this.text = (String)v.get(0);
            } else {
                this.text = ((String)v.get(0)).trim();
                try {
                    this.option = this.getOptionalLayout((String)v.get(1));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public LayoutEntry(Vector parsedEntries) {
        int i;
        String blockStart = null;
        String blockEnd = null;
        Vector<StringInt> blockEntries = null;
        Vector<LayoutEntry> tmpEntries = new Vector<LayoutEntry>();
        StringInt si = (StringInt)parsedEntries.get(0);
        blockStart = si.s;
        si = (StringInt)parsedEntries.get(parsedEntries.size() - 1);
        blockEnd = si.s;
        if (!blockStart.equals(blockEnd)) {
            System.err.println("Field start and end entry must be equal.");
        }
        this.type = 3;
        this.text = si.s;
        for (i = 1; i < parsedEntries.size() - 1; ++i) {
            si = (StringInt)parsedEntries.get(i);
            if (si.i != 1 && si.i != 2) {
                if (si.i == 3) {
                    blockEntries = new Vector<StringInt>();
                    blockStart = si.s;
                } else if (si.i == 4) {
                    if (blockStart.equals(si.s)) {
                        blockEntries.add(si);
                        LayoutEntry le = new LayoutEntry(blockEntries);
                        tmpEntries.add(le);
                        blockEntries = null;
                    } else {
                        System.err.println("Nested field entries are not implemented !!!");
                    }
                } else if (si.i == 5) {
                    // empty if block
                }
            }
            if (blockEntries == null) {
                tmpEntries.add(new LayoutEntry(si));
                continue;
            }
            blockEntries.add(si);
        }
        this.layoutEntries = new LayoutEntry[tmpEntries.size()];
        for (i = 0; i < tmpEntries.size(); ++i) {
            this.layoutEntries[i] = (LayoutEntry)tmpEntries.get(i);
        }
    }

    public String doLayout(BibtexEntry bibtex) {
        if (this.type == 1) {
            return this.text;
        }
        if (this.type == 2) {
            if (this.text.equals("bibtextype")) {
                return bibtex.getType().getName();
            }
            String field = (String)bibtex.getField(this.text);
            if (field == null) {
                return null;
            }
            return field;
        }
        if (this.type == 3) {
            String field = (String)bibtex.getField(this.text);
            if (field == null) {
                return null;
            }
            StringBuffer sb = new StringBuffer(100);
            boolean previousSkipped = false;
            for (int i = 0; i < this.layoutEntries.length; ++i) {
                String fieldText = this.layoutEntries[i].doLayout(bibtex);
                if (fieldText == null) {
                    if (i + 1 < this.layoutEntries.length && this.layoutEntries[i + 1].doLayout(bibtex).trim().length() == 0) {
                        ++i;
                        previousSkipped = true;
                        continue;
                    }
                } else if (previousSkipped) {
                    int eol;
                    for (eol = 0; eol < fieldText.length() && (fieldText.charAt(eol) == '\n' || fieldText.charAt(eol) == '\r'); ++eol) {
                    }
                    if (eol < fieldText.length()) {
                        sb.append(fieldText.substring(eol));
                    }
                } else {
                    sb.append(fieldText);
                }
                previousSkipped = false;
            }
            return sb.toString();
        }
        if (this.type != 4 && this.type == 5) {
            String field;
            String fieldEntry = this.text.equals("bibtextype") ? bibtex.getType().getName() : ((field = (String)bibtex.getField(this.text)) == null ? "" : field);
            if (this.option != null) {
                fieldEntry = this.option.format(fieldEntry);
            }
            return fieldEntry;
        }
        return "";
    }

    private LayoutFormatter getOptionalLayout(String formatterName) throws Exception {
        LayoutFormatter formatter;
        try {
            formatter = (LayoutFormatter)Class.forName(formatterName).newInstance();
        }
        catch (ClassNotFoundException ex) {
            throw new Exception(formatterName + " not found.");
        }
        catch (InstantiationException ex) {
            throw new Exception(formatterName + " can not be instantiated.");
        }
        catch (IllegalAccessException ex) {
            throw new Exception(formatterName + " can't be accessed.");
        }
        if (formatter == null) {
            throw new Exception(formatterName + " not found.");
        }
        return formatter;
    }
}

