/*
 * Decompiled with CFR 0.152.
 */
package jabref;

import jabref.BasePanel;
import jabref.JabRefFrame;
import jabref.JabRefPreferences;
import jabref.MetaData;
import jabref.SidePane;
import jabref.SidePaneComponent;
import jabref.groups.GroupSelector;
import java.util.HashMap;
import java.util.Vector;

public class SidePaneManager {
    JabRefFrame frame;
    BasePanel panel;
    SidePane sidep;
    JabRefPreferences prefs;
    MetaData metaData;
    HashMap components = new HashMap();
    private int visibleComponents = 0;

    public SidePaneManager(JabRefFrame frame, BasePanel panel, JabRefPreferences prefs2, MetaData metaData) {
        this.prefs = prefs2;
        this.panel = panel;
        this.metaData = metaData;
        this.frame = frame;
        this.sidep = new SidePane(panel);
    }

    public void populatePanel() {
        if (this.prefs.getBoolean("groupSelectorVisible") && this.metaData.getData("groups") != null) {
            this.panel.groupSelector = new GroupSelector(this.frame, this.panel, this.metaData.getData("groups"), this, this.prefs);
            this.add("groups", this.panel.groupSelector);
        }
        if (this.components.size() > 0) {
            this.panel.setLeftComponent(this.sidep);
        } else {
            this.panel.setLeftComponent(null);
        }
    }

    public void togglePanel(String name) {
        if (this.components.get(name) != null) {
            if (!((SidePaneComponent)this.components.get(name)).isVisible()) {
                ++this.visibleComponents;
                ((SidePaneComponent)this.components.get(name)).setVisible(true);
                if (this.visibleComponents == 1) {
                    this.panel.setLeftComponent(this.sidep);
                }
                ((SidePaneComponent)this.components.get(name)).componentOpening();
                ((SidePaneComponent)this.components.get(name)).setVisibility(true);
            } else {
                this.hideAway((SidePaneComponent)this.components.get(name));
            }
            return;
        }
        if (name.equals("groups")) {
            if (this.metaData.getData("groups") == null) {
                this.metaData.putData("groups", new Vector());
            }
            this.panel.groupSelector = new GroupSelector(this.frame, this.panel, this.metaData.getData("groups"), this, this.prefs);
            this.add("groups", this.panel.groupSelector);
        }
    }

    public synchronized void ensureVisible(String name) {
        Object o = this.components.get(name);
        if (o == null || ((SidePaneComponent)o).hasVisibility()) {
            return;
        }
        this.togglePanel(name);
    }

    public synchronized void add(String name, SidePaneComponent comp) {
        this.sidep.add(comp);
        this.components.put(name, comp);
        ++this.visibleComponents;
        if (this.visibleComponents == 1) {
            this.panel.setLeftComponent(this.sidep);
        }
        comp.componentOpening();
        comp.setVisibility(true);
    }

    public synchronized void register(String name, SidePaneComponent comp) {
        comp.setVisible(false);
        this.sidep.add(comp);
        this.components.put(name, comp);
    }

    public synchronized void hideAway(SidePaneComponent comp) {
        comp.componentClosing();
        comp.setVisible(false);
        comp.setVisibility(false);
        --this.visibleComponents;
        if (this.visibleComponents == 0) {
            this.panel.remove(this.sidep);
        }
    }
}

