/*
 * Decompiled with CFR 0.152.
 */
package jabref;

import jabref.GUIGlobals;
import jabref.GeneralTab;
import jabref.Globals;
import jabref.JabRefFrame;
import jabref.JabRefPreferences;
import jabref.PrefsTab;
import jabref.TabLabelPattern;
import jabref.TablePrefsTab;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class PrefsDialog2
extends JDialog {
    private JabRefPreferences _prefs;
    JPanel upper = new JPanel();
    JPanel lower = new JPanel();
    GridBagLayout gbl = new GridBagLayout();
    GridBagConstraints con = new GridBagConstraints();
    JTabbedPane tabbed = new JTabbedPane();
    JabRefFrame frame;

    public PrefsDialog2(JabRefFrame parent, JabRefPreferences prefs2) {
        super(parent, Globals.lang("JabRef preferences"), false);
        this._prefs = prefs2;
        this.frame = parent;
        this.getContentPane().setLayout(this.gbl);
        this.con.weighty = 1.0;
        this.con.weightx = 1.0;
        this.con.fill = 1;
        this.con.gridwidth = 0;
        this.con.insets = new Insets(5, 5, 0, 5);
        this.gbl.setConstraints(this.tabbed, this.con);
        this.getContentPane().add(this.tabbed);
        this.con.weighty = 0.0;
        this.con.gridheight = 0;
        this.gbl.setConstraints(this.lower, this.con);
        this.lower.setBackground(GUIGlobals.lightGray);
        this.getContentPane().setBackground(GUIGlobals.lightGray);
        this.getContentPane().add(this.lower);
        this.tabbed.addTab(Globals.lang("General"), new GeneralTab(this.frame, this._prefs));
        this.tabbed.addTab(Globals.lang("Table"), new TablePrefsTab(this._prefs, parent));
        this.tabbed.addTab(Globals.lang("Key pattern"), new TabLabelPattern(this._prefs, parent.helpDiag));
        JButton ok = new JButton(Globals.lang("Ok"));
        JButton cancel = new JButton(Globals.lang("Cancel"));
        ok.addActionListener(new OkAction());
        cancel.addActionListener(new CancelAction());
        this.lower.add(ok);
        this.lower.add(cancel);
        this.pack();
    }

    class OkAction
    extends AbstractAction {
        public OkAction() {
            super("Ok");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (int i = 0; i < PrefsDialog2.this.tabbed.getTabCount(); ++i) {
                ((PrefsTab)((Object)PrefsDialog2.this.tabbed.getComponentAt(i))).storeSettings();
            }
            PrefsDialog2.this.frame.setupAllTables();
            PrefsDialog2.this.frame.output(Globals.lang("Preferences recorded."));
            PrefsDialog2.this.dispose();
        }
    }

    class CancelAction
    extends AbstractAction {
        public CancelAction() {
            super("Cancel");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            new Thread(){

                @Override
                public void run() {
                    PrefsDialog2.this.dispose();
                }
            }.start();
        }
    }
}

