/*
 * Decompiled with CFR 0.152.
 */
package jabref;

import jabref.GUIGlobals;
import jabref.JabRef;
import jabref.JabRefPreferences;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Stack;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;

public class HelpContent
extends JEditorPane {
    JScrollPane pane = new JScrollPane(this, 20, 31);
    private Stack history;
    private Stack forw;
    JabRefPreferences prefs;

    public HelpContent(JabRefPreferences prefs_) {
        this.prefs = prefs_;
        this.history = new Stack();
        this.forw = new Stack();
        this.setContentType("text/html");
        this.setText("");
        this.setEditable(false);
    }

    public boolean back() {
        if (!this.history.empty()) {
            URL prev = (URL)this.history.pop();
            this.forw.push(this.getPage());
            this.setPageOnly(prev);
        }
        return !this.history.empty();
    }

    public boolean forward() {
        if (!this.forw.empty()) {
            URL next = (URL)this.forw.pop();
            this.history.push(this.getPage());
            this.setPageOnly(next);
        }
        return !this.forw.empty();
    }

    public void reset() {
        this.forw.removeAllElements();
        this.history.removeAllElements();
    }

    @Override
    public void setPage(String filename) {
        String middle = this.prefs.get("language") + "/";
        if (middle.equals("en/")) {
            middle = "";
        }
        URL old = this.getPage();
        URL translatedFile = JabRef.class.getResource(GUIGlobals.helpPre + middle + filename);
        try {
            super.setPage(translatedFile);
        }
        catch (IOException ex) {
            URL file2 = HelpContent.class.getResource(GUIGlobals.helpPre + filename);
            this.setPageOnly(file2);
            this.forw.removeAllElements();
            if (old != null) {
                this.history.push(old);
            }
            return;
        }
        this.forw.removeAllElements();
        if (old != null) {
            this.history.push(old);
        }
    }

    @Override
    public void setPage(URL url) {
        File f = new File(url.getPath());
        this.setPage(f.getName());
    }

    private void setPageOnly(URL url) {
        try {
            super.setPage(url);
        }
        catch (IOException ex) {
            System.out.println("Error: could not read help file: '" + url.getFile() + "'");
        }
    }

    public JComponent getPane() {
        return this.pane;
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        super.paintComponent(g2);
    }
}

