/*
 * Decompiled with CFR 0.152.
 */
package jabref;

import jabref.GUIGlobals;
import jabref.Globals;
import jabref.HelpAction;
import jabref.JabRefFrame;
import jabref.JabRefPreferences;
import jabref.PrefsTab;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class GeneralTab
extends JPanel
implements PrefsTab {
    GridBagLayout gbl = new GridBagLayout();
    GridBagConstraints con = new GridBagConstraints();
    private JCheckBox autoOpenForm;
    private JCheckBox backup;
    private JCheckBox openLast;
    private JCheckBox defSource;
    private JCheckBox editSource;
    private JCheckBox defSort;
    private JCheckBox ctrlClick;
    private JCheckBox disableOnMultiple;
    private JCheckBox useOwner;
    private JTextField groupField = new JTextField(15);
    private JTextField defOwnerField;
    JabRefPreferences _prefs;
    JabRefFrame _frame;
    private JComboBox language = new JComboBox<Object>(GUIGlobals.LANGUAGES.keySet().toArray());
    JTextField pdfDir;
    JTextField pdf;
    JTextField ps;
    JTextField html;
    private HelpAction ownerHelp;
    private HelpAction pdfHelp;

    public GeneralTab(JabRefFrame frame, JabRefPreferences prefs2) {
        this._prefs = prefs2;
        this._frame = frame;
        this.setLayout(this.gbl);
        this.con.weightx = 0.0;
        this.con.insets = new Insets(5, 10, 5, 10);
        this.con.fill = 2;
        this.autoOpenForm = new JCheckBox(Globals.lang("Open editor when a new entry is created"), this._prefs.getBoolean("autoOpenForm"));
        this.openLast = new JCheckBox(Globals.lang("Open last edited databases at startup"), this._prefs.getBoolean("openLastEdited"));
        this.backup = new JCheckBox(Globals.lang("Backup old file when saving"), this._prefs.getBoolean("backup"));
        this.defSource = new JCheckBox(Globals.lang("Show BibTeX source by default"), this._prefs.getBoolean("defaultShowSource"));
        this.editSource = new JCheckBox(Globals.lang("Enable source editing"), this._prefs.getBoolean("enableSourceEditing"));
        this.defSort = new JCheckBox(Globals.lang("Sort Automatically"), this._prefs.getBoolean("defaultAutoSort"));
        this.ctrlClick = new JCheckBox(Globals.lang("Open right-click menu with Ctrl+left button"), this._prefs.getBoolean("ctrlClick"));
        this.disableOnMultiple = new JCheckBox(Globals.lang("Disable entry editor when multiple entries are selected"), this._prefs.getBoolean("disableOnMultipleSelection"));
        this.useOwner = new JCheckBox(Globals.lang("Mark new entries with owner name") + ":", this._prefs.getBoolean("useOwner"));
        JPanel general = new JPanel();
        JPanel external = new JPanel();
        this.defOwnerField = new JTextField(this._prefs.get("defaultOwner"));
        this.groupField = new JTextField(this._prefs.get("groupsDefaultField"), 15);
        general.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Globals.lang("Miscellaneous")));
        external.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Globals.lang("External programs")));
        this.ownerHelp = new HelpAction(frame.helpDiag, GUIGlobals.ownerHelp, "Help", GUIGlobals.helpSmallIconFile);
        this.pdfHelp = new HelpAction(frame.helpDiag, GUIGlobals.pdfHelp, "Help", GUIGlobals.helpSmallIconFile);
        general.setLayout(this.gbl);
        external.setLayout(this.gbl);
        this.con.gridwidth = 1;
        this.gbl.setConstraints(this.openLast, this.con);
        general.add(this.openLast);
        this.con.gridwidth = 0;
        this.gbl.setConstraints(this.autoOpenForm, this.con);
        general.add(this.autoOpenForm);
        this.con.gridwidth = 1;
        this.gbl.setConstraints(this.backup, this.con);
        general.add(this.backup);
        this.con.gridwidth = 0;
        this.gbl.setConstraints(this.defSource, this.con);
        general.add(this.defSource);
        this.con.gridwidth = 1;
        this.gbl.setConstraints(this.disableOnMultiple, this.con);
        general.add(this.disableOnMultiple);
        this.con.gridwidth = 0;
        this.gbl.setConstraints(this.ctrlClick, this.con);
        general.add(this.ctrlClick);
        this.con.gridwidth = 1;
        this.gbl.setConstraints(this.useOwner, this.con);
        general.add(this.useOwner);
        this.con.weightx = 1.0;
        this.con.insets = new Insets(5, 10, 5, 2);
        this.gbl.setConstraints(this.defOwnerField, this.con);
        general.add(this.defOwnerField);
        this.con.weightx = 0.0;
        this.con.gridwidth = 0;
        this.con.insets = new Insets(5, 2, 5, 10);
        JButton hlp = new JButton(this.ownerHelp);
        hlp.setText(null);
        hlp.setPreferredSize(new Dimension(24, 24));
        this.gbl.setConstraints(hlp, this.con);
        general.add(hlp);
        this.con.gridwidth = 1;
        this.con.insets = new Insets(5, 10, 5, 10);
        JLabel lab = new JLabel(Globals.lang("Default grouping field") + ":");
        lab.setHorizontalAlignment(2);
        this.gbl.setConstraints(lab, this.con);
        general.add(lab);
        this.con.gridwidth = 0;
        this.gbl.setConstraints(this.groupField, this.con);
        general.add(this.groupField);
        String oldLan = this._prefs.get("language");
        int ilk = 0;
        Iterator i = GUIGlobals.LANGUAGES.keySet().iterator();
        while (i.hasNext()) {
            if (GUIGlobals.LANGUAGES.get(i.next()).equals(oldLan)) {
                this.language.setSelectedIndex(ilk);
            }
            ++ilk;
        }
        this.con.gridwidth = 1;
        lab = new JLabel(Globals.lang("Language") + ":");
        lab.setHorizontalAlignment(2);
        this.gbl.setConstraints(lab, this.con);
        general.add(lab);
        this.con.gridwidth = 0;
        this.gbl.setConstraints(this.language, this.con);
        general.add(this.language);
        this.pdfDir = new JTextField(this._prefs.get("pdfDirectory"), 30);
        this.pdf = new JTextField(this._prefs.get("pdfviewer"), 30);
        this.ps = new JTextField(this._prefs.get("psviewer"), 30);
        this.html = new JTextField(this._prefs.get("htmlviewer"), 30);
        this.con.gridwidth = 1;
        this.con.weightx = 0.0;
        this.con.insets = new Insets(5, 10, 15, 10);
        this.con.fill = 1;
        lab = new JLabel(Globals.lang("Main PDF directory") + ":");
        this.gbl.setConstraints(lab, this.con);
        external.add(lab);
        this.con.weightx = 1.0;
        this.gbl.setConstraints(this.pdfDir, this.con);
        external.add(this.pdfDir);
        this.con.weightx = 0.0;
        this.con.insets = new Insets(5, 10, 15, 2);
        JButton browse = new JButton(Globals.lang("Browse"));
        browse.addActionListener(new BrowseAction(this.pdfDir, true));
        this.gbl.setConstraints(browse, this.con);
        external.add(browse);
        this.con.insets = new Insets(5, 2, 15, 10);
        this.con.gridwidth = 0;
        hlp = new JButton(this.pdfHelp);
        hlp.setText(null);
        hlp.setPreferredSize(new Dimension(24, 24));
        this.gbl.setConstraints(hlp, this.con);
        external.add(hlp);
        this.con.gridwidth = 1;
        this.con.fill = 2;
        this.con.insets = new Insets(5, 10, 5, 10);
        lab = new JLabel(Globals.lang("Path to PDF viewer") + ":");
        this.gbl.setConstraints(lab, this.con);
        external.add(lab);
        this.con.weightx = 1.0;
        this.gbl.setConstraints(this.pdf, this.con);
        external.add(this.pdf);
        this.con.weightx = 0.0;
        this.con.gridwidth = 0;
        browse = new JButton(Globals.lang("Browse"));
        browse.addActionListener(new BrowseAction(this.pdf, false));
        this.gbl.setConstraints(browse, this.con);
        external.add(browse);
        this.con.gridwidth = 1;
        this.con.fill = 2;
        lab = new JLabel(Globals.lang("Path to PS viewer") + ":");
        this.gbl.setConstraints(lab, this.con);
        external.add(lab);
        this.con.weightx = 1.0;
        this.gbl.setConstraints(this.ps, this.con);
        external.add(this.ps);
        this.con.weightx = 0.0;
        this.con.gridwidth = 0;
        browse = new JButton(Globals.lang("Browse"));
        browse.addActionListener(new BrowseAction(this.ps, false));
        this.gbl.setConstraints(browse, this.con);
        external.add(browse);
        this.con.gridwidth = 1;
        lab = new JLabel(Globals.lang("Path to HTML viewer") + ":");
        this.gbl.setConstraints(lab, this.con);
        external.add(lab);
        this.con.weightx = 1.0;
        this.gbl.setConstraints(this.html, this.con);
        external.add(this.html);
        this.con.gridwidth = 0;
        this.con.weightx = 0.0;
        browse = new JButton(Globals.lang("Browse"));
        browse.addActionListener(new BrowseAction(this.html, false));
        this.gbl.setConstraints(browse, this.con);
        external.add(browse);
        this.con.gridwidth = 1;
        this.con.fill = 2;
        this.con.weightx = 1.0;
        this.con.weightx = 0.0;
        this.con.gridwidth = 0;
        browse = new JButton(Globals.lang("Browse"));
        this.gbl.setConstraints(browse, this.con);
        external.add(browse);
        this.con.gridwidth = 0;
        this.gbl.setConstraints(general, this.con);
        this.add(general);
        this.gbl.setConstraints(external, this.con);
        this.add(external);
    }

    @Override
    public void storeSettings() {
        this._prefs.putBoolean("autoOpenForm", this.autoOpenForm.isSelected());
        this._prefs.putBoolean("backup", this.backup.isSelected());
        this._prefs.putBoolean("openLastEdited", this.openLast.isSelected());
        this._prefs.putBoolean("defaultShowSource", this.defSource.isSelected());
        this._prefs.putBoolean("enableSourceEditing", this.editSource.isSelected());
        this._prefs.putBoolean("disableOnMultipleSelection", this.disableOnMultiple.isSelected());
        this._prefs.putBoolean("useOwner", this.useOwner.isSelected());
        this._prefs.putBoolean("ctrlClick", this.ctrlClick.isSelected());
        this._prefs.put("defaultOwner", this.defOwnerField.getText().trim());
        this._prefs.put("groupsDefaultField", this.groupField.getText().trim());
        this._prefs.put("pdfDirectory", this.pdfDir.getText());
        this._prefs.put("pdfviewer", this.pdf.getText());
        this._prefs.put("psviewer", this.ps.getText());
        this._prefs.put("htmlviewer", this.html.getText());
        if (!GUIGlobals.LANGUAGES.get(this.language.getSelectedItem()).equals(this._prefs.get("language"))) {
            this._prefs.put("language", GUIGlobals.LANGUAGES.get(this.language.getSelectedItem()).toString());
            Globals.setLanguage(GUIGlobals.LANGUAGES.get(this.language.getSelectedItem()).toString(), "");
            JOptionPane.showMessageDialog(null, Globals.lang("You have changed the language setting. You must restart JabRef for this to come into effect."), Globals.lang("Changed language settings"), 2);
        }
    }

    class BrowseAction
    extends AbstractAction {
        JTextField comp;
        boolean dir;

        public BrowseAction(JTextField tc, boolean dir2) {
            super(Globals.lang("Browse"));
            this.dir = dir2;
            this.comp = tc;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String chosen = null;
            chosen = this.dir ? Globals.getNewDir(GeneralTab.this._frame, GeneralTab.this._prefs, new File(this.comp.getText()), "_non__", 0, false) : Globals.getNewFile(GeneralTab.this._frame, GeneralTab.this._prefs, new File(this.comp.getText()), "_non__", 0, false);
            if (chosen != null) {
                File newFile = new File(chosen);
                this.comp.setText(newFile.getPath());
            }
        }
    }
}

