/*
 * Decompiled with CFR 0.152.
 */
package jabref;

import jabref.BasePanel;
import jabref.EntryCustomizationDialog;
import jabref.GUIGlobals;
import jabref.GenFieldsCustomizer_cancel_actionAdapter;
import jabref.GenFieldsCustomizer_ok_actionAdapter;
import jabref.GenFieldsCustomizer_revert_actionAdapter;
import jabref.Globals;
import jabref.JabRefFrame;
import jabref.Util;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;

public class GenFieldsCustomizer
extends JDialog {
    JPanel jPanel2 = new JPanel();
    JButton ok = new JButton();
    JButton cancel = new JButton();
    TitledBorder titledBorder1;
    TitledBorder titledBorder2;
    JLabel jLabel1 = new JLabel();
    JPanel jPanel3 = new JPanel();
    JPanel jPanel4 = new JPanel();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JScrollPane jScrollPane1 = new JScrollPane();
    JLabel jLabel2 = new JLabel();
    JTextArea fieldsArea = new JTextArea();
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    JabRefFrame parent;
    JButton revert = new JButton();
    EntryCustomizationDialog diag;

    public GenFieldsCustomizer(JabRefFrame frame, EntryCustomizationDialog diag) {
        super(frame, Globals.lang("Set general fields"), false);
        this.parent = frame;
        this.diag = diag;
        try {
            this.jbInit();
            this.setSize(new Dimension(400, 200));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.ok.setText(Globals.lang("Ok"));
        this.ok.addActionListener(new GenFieldsCustomizer_ok_actionAdapter(this));
        this.cancel.setText(Globals.lang("Cancel"));
        this.cancel.addActionListener(new GenFieldsCustomizer_cancel_actionAdapter(this));
        this.jPanel2.setBackground(GUIGlobals.lightGray);
        this.jLabel1.setText(Globals.lang("Delimit fields with semicolon, ex.") + ": url;pdf;note");
        this.jPanel3.setLayout(this.gridBagLayout2);
        this.jPanel4.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel4.setLayout(this.gridBagLayout1);
        this.jLabel2.setText(Globals.lang("General fields"));
        this.fieldsArea.setText(this.parent.prefs.get("generalFields"));
        this.jPanel3.setBackground(GUIGlobals.lightGray);
        this.revert.setText(Globals.lang("Default"));
        this.revert.addActionListener(new GenFieldsCustomizer_revert_actionAdapter(this));
        this.getContentPane().add((Component)this.jPanel2, "South");
        this.jPanel2.add((Component)this.ok, null);
        this.jPanel2.add((Component)this.revert, null);
        this.jPanel2.add((Component)this.cancel, null);
        this.getContentPane().add((Component)this.jPanel3, "Center");
        this.jPanel3.add((Component)this.jLabel1, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.jPanel3.add((Component)this.jPanel4, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 318, 193));
        this.jPanel4.add((Component)this.jScrollPane1, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.jScrollPane1.getViewport().add((Component)this.fieldsArea, null);
        this.jPanel4.add((Component)this.jLabel2, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        ActionMap am = this.jPanel2.getActionMap();
        InputMap im = this.jPanel2.getInputMap(2);
        im.put(GUIGlobals.exitDialog, "close");
        am.put("close", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GenFieldsCustomizer.this.dispose();
                GenFieldsCustomizer.this.diag.requestFocus();
            }
        });
    }

    void ok_actionPerformed(ActionEvent e) {
        String delimStr = this.fieldsArea.getText().replaceAll("\\s+", "").replaceAll("\\n+", "").trim();
        this.parent.prefs.putStringArray("generalFields", Util.delimToStringArray(delimStr, ";"));
        for (int i = 0; i < this.parent.tabbedPane.getTabCount(); ++i) {
            BasePanel bp = (BasePanel)this.parent.tabbedPane.getComponentAt(i);
            bp.entryEditors.clear();
        }
        this.dispose();
        this.diag.requestFocus();
    }

    void cancel_actionPerformed(ActionEvent e) {
        this.dispose();
        this.diag.requestFocus();
    }

    void revert_actionPerformed(ActionEvent e) {
        this.fieldsArea.setText((String)this.parent.prefs.defaults.get("generalFields"));
    }
}

