/*
 * Decompiled with CFR 0.152.
 */
package jabref;

import jabref.FieldEditor;
import jabref.GUIGlobals;
import jabref.Globals;
import jabref.Util;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class FieldTextArea
extends JTextArea
implements FieldEditor {
    private static final long serialVersionUID = 1L;
    Dimension PREFERRED_SIZE;
    protected JScrollPane sp;
    protected JLabel label;
    protected String fieldName;

    public FieldTextArea(String fieldName_, String content) {
        super(content);
        this.addFocusListener(Globals.focusListener);
        this.sp = new JScrollPane(this, 20, 31);
        this.setLineWrap(true);
        this.setWrapStyleWord(true);
        this.fieldName = fieldName_;
        this.label = new JLabel(Util.nCase(this.fieldName), 0);
        this.label.setBorder(BorderFactory.createEtchedBorder(GUIGlobals.lightGray, Color.gray));
        this.label.setOpaque(true);
        this.label.setBackground(GUIGlobals.lightGray);
        this.setBackground(GUIGlobals.validFieldBackground);
        if (content != null && content.length() > 0) {
            this.label.setForeground(GUIGlobals.validFieldColor);
        } else {
            this.label.setForeground(GUIGlobals.nullFieldColor);
        }
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.PREFERRED_SIZE;
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        RenderingHints rh = g2.getRenderingHints();
        rh.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        rh.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2.setRenderingHints(rh);
        super.paintComponent(g2);
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String newName) {
        this.fieldName = newName;
    }

    @Override
    public JLabel getLabel() {
        return this.label;
    }

    @Override
    public void setLabelColor(Color c) {
        this.label.setForeground(c);
    }

    @Override
    public JComponent getPane() {
        return this.sp;
    }
}

