/*
 * Decompiled with CFR 0.152.
 */
package jabref;

import jabref.Globals;
import jabref.JabRefFileChooser;
import jabref.JabRefPreferences;
import jabref.PrefsTab;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

class ExternalProgramsTab
extends JPanel
implements PrefsTab {
    private static final long serialVersionUID = 1L;
    JabRefPreferences _prefs;
    private GridBagLayout gbl = new GridBagLayout();
    private GridBagConstraints con = new GridBagConstraints();
    JTextField pdf;
    JTextField ps;
    JTextField html;
    JTextField lyx;

    public ExternalProgramsTab(JabRefPreferences prefs2) {
        this._prefs = prefs2;
        this.pdf = new JTextField(this._prefs.get("pdfviewer"), 30);
        this.ps = new JTextField(this._prefs.get("psviewer"), 30);
        this.html = new JTextField(this._prefs.get("htmlviewer"), 30);
        this.lyx = new JTextField(this._prefs.get("lyxpipe"), 30);
        this.setLayout(this.gbl);
        this.con.weightx = 0.0;
        this.con.insets = new Insets(10, 10, 10, 10);
        this.con.fill = 2;
        JLabel lab = new JLabel(Globals.lang("Path to PDF viewer") + ":");
        this.gbl.setConstraints(lab, this.con);
        this.add(lab);
        this.con.weightx = 1.0;
        this.gbl.setConstraints(this.pdf, this.con);
        this.add(this.pdf);
        this.con.weightx = 0.0;
        this.con.gridwidth = 0;
        JButton browse = new JButton(Globals.lang("Browse"));
        browse.addActionListener(new BrowseAction(this.pdf));
        this.gbl.setConstraints(browse, this.con);
        this.add(browse);
        this.con.gridwidth = 1;
        this.con.fill = 2;
        lab = new JLabel(Globals.lang("Path to PS viewer") + ":");
        this.gbl.setConstraints(lab, this.con);
        this.add(lab);
        this.con.weightx = 1.0;
        this.gbl.setConstraints(this.ps, this.con);
        this.add(this.ps);
        this.con.weightx = 0.0;
        this.con.gridwidth = 0;
        browse = new JButton(Globals.lang("Browse"));
        browse.addActionListener(new BrowseAction(this.ps));
        this.gbl.setConstraints(browse, this.con);
        this.add(browse);
        this.con.gridwidth = 1;
        lab = new JLabel(Globals.lang("Path to HTML viewer") + ":");
        this.gbl.setConstraints(lab, this.con);
        this.add(lab);
        this.con.weightx = 1.0;
        this.gbl.setConstraints(this.html, this.con);
        this.add(this.html);
        this.con.gridwidth = 0;
        this.con.weightx = 0.0;
        browse = new JButton(Globals.lang("Browse"));
        browse.addActionListener(new BrowseAction(this.html));
        this.gbl.setConstraints(browse, this.con);
        this.add(browse);
        this.con.gridwidth = 1;
        this.con.fill = 2;
        lab = new JLabel(Globals.lang("Path to LyX pipe") + ":");
        this.gbl.setConstraints(lab, this.con);
        this.add(lab);
        this.con.weightx = 1.0;
        this.gbl.setConstraints(this.lyx, this.con);
        this.add(this.lyx);
        this.con.weightx = 0.0;
        browse = new JButton(Globals.lang("Browse"));
        browse.addActionListener(new BrowseAction(this.lyx));
        this.gbl.setConstraints(browse, this.con);
        this.add(browse);
    }

    @Override
    public void storeSettings() {
        this._prefs.put("pdfviewer", this.pdf.getText());
        this._prefs.put("psviewer", this.ps.getText());
        this._prefs.put("htmlviewer", this.html.getText());
        this._prefs.put("lyxpipe", this.lyx.getText());
    }

    class BrowseAction
    extends AbstractAction {
        JTextField comp;

        public BrowseAction(JTextField tc) {
            super(Globals.lang("Browse"));
            this.comp = tc;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JabRefFileChooser chooser = new JabRefFileChooser(new File(this.comp.getText()));
            int returnVal = chooser.showOpenDialog(null);
            if (returnVal == 0) {
                File newFile = chooser.getSelectedFile();
                this.comp.setText(newFile.getPath());
            }
        }
    }
}

