/*
 * Decompiled with CFR 0.152.
 */
package jabref;

import jabref.BasePanel;
import jabref.BibtexEntry;
import jabref.EntryTableModel;
import jabref.GUIGlobals;
import jabref.Globals;
import jabref.JabRefPreferences;
import jabref.RightClickMenu;
import jabref.Util;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;

public class EntryTable
extends JTable {
    final int PREFERRED_WIDTH = 400;
    final int PREFERRED_HEIGHT = 30;
    JScrollPane sp = new JScrollPane(this);
    JPopupMenu rightClickMenu = null;
    EntryTableModel tableModel;
    JabRefPreferences prefs;
    protected boolean showingSearchResults = false;
    protected boolean showingGroup = false;
    private EntryTable ths = this;
    private boolean antialiasing = true;
    private boolean ctrlClick = false;
    private boolean selectionListenerOn = true;
    private BasePanel panel;
    private ListSelectionListener previewListener = null;
    private Renderer defRenderer = new Renderer(GUIGlobals.tableBackground);
    private Renderer reqRenderer = new Renderer(GUIGlobals.tableReqFieldBackground);
    private Renderer optRenderer = new Renderer(GUIGlobals.tableOptFieldBackground);
    private Renderer incRenderer = new Renderer(GUIGlobals.tableIncompleteEntryBackground);
    private Renderer grayedOutRenderer = new Renderer(GUIGlobals.grayedOutBackground, GUIGlobals.grayedOutText);
    private Renderer veryGrayedOutRenderer = new Renderer(GUIGlobals.veryGrayedOutBackground, GUIGlobals.veryGrayedOutText);
    private Renderer maybeIncRenderer = new Renderer(GUIGlobals.maybeIncompleteEntryBackground);
    private Renderer markedRenderer = new Renderer(GUIGlobals.markedEntryBackground);

    public EntryTable(EntryTableModel tm_, BasePanel panel_, JabRefPreferences prefs_) {
        super(tm_);
        this.tableModel = tm_;
        this.panel = panel_;
        this.addFocusListener(Globals.focusListener);
        this.prefs = prefs_;
        this.antialiasing = this.prefs.getBoolean("antialias");
        this.ctrlClick = this.prefs.getBoolean("ctrlClick");
        this.getTableHeader().setReorderingAllowed(false);
        this.setGridColor(GUIGlobals.gridColor);
        this.setShowVerticalLines(true);
        this.setShowHorizontalLines(true);
        this.setColumnSelectionAllowed(false);
        this.setRowSelectionAllowed(true);
        this.setAutoResizeMode(this.prefs.getInt("autoResizeMode"));
        DefaultCellEditor dce = new DefaultCellEditor(new JTextField());
        dce.setClickCountToStart(2);
        this.setDefaultEditor(String.class, dce);
        this.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int col = EntryTable.this.getTableHeader().columnAtPoint(e.getPoint());
                if (col >= EntryTable.this.tableModel.padleft) {
                    String s = EntryTable.this.tableModel.getColumnName(col).toLowerCase();
                    if (s.equals("")) {
                        return;
                    }
                    if (!s.equals(EntryTable.this.prefs.get("priSort"))) {
                        EntryTable.this.prefs.put("priSort", s);
                    } else {
                        EntryTable.this.prefs.putBoolean("priDescending", !EntryTable.this.prefs.getBoolean("priDescending"));
                    }
                    EntryTable.this.tableModel.remap();
                    EntryTable.this.repaint();
                }
            }
        });
        this.addMouseListener(new TableClickListener());
        this.addSelectionListener();
        this.setWidths();
        this.sp.getViewport().setBackground(GUIGlobals.tableBackground);
        this.updateFont();
    }

    public void addSelectionListener() {
        if (this.previewListener == null) {
            this.previewListener = new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!EntryTable.this.selectionListenerOn) {
                        return;
                    }
                    if (!e.getValueIsAdjusting()) {
                        if (EntryTable.this.getSelectedRowCount() == 1) {
                            int row = EntryTable.this.getSelectedRow();
                            if (row >= 0) {
                                EntryTable.this.panel.updateWiewToSelected(EntryTable.this.panel.database().getEntryById(EntryTable.this.tableModel.getNameFromNumber(row)));
                            }
                        } else if (EntryTable.this.prefs.getBoolean("disableOnMultipleSelection")) {
                            EntryTable.this.panel.setEntryEditorEnabled(false);
                        }
                    }
                }
            };
        }
        this.getSelectionModel().addListSelectionListener(this.previewListener);
    }

    public void disablePreviewListener() {
        this.getSelectionModel().removeListSelectionListener(this.previewListener);
    }

    @Override
    public void setRowSelectionInterval(int row1, int row2) {
        this.selectionListenerOn = false;
        super.setRowSelectionInterval(row1, row2);
        this.selectionListenerOn = true;
    }

    public void setWidths() {
        int i;
        int ncWidth = this.prefs.getInt("numberColWidth");
        String[] widths = this.prefs.getStringArray("columnWidths");
        TableColumnModel cm = this.getColumnModel();
        cm.getColumn(0).setPreferredWidth(ncWidth);
        for (i = 1; i < this.tableModel.padleft; ++i) {
            cm.getColumn(i).setPreferredWidth(GUIGlobals.WIDTH_ICON_COL);
        }
        for (i = this.tableModel.padleft; i < this.getModel().getColumnCount(); ++i) {
            try {
                cm.getColumn(i).setPreferredWidth(Integer.parseInt(widths[i - this.tableModel.padleft]));
                continue;
            }
            catch (Throwable ex) {
                Globals.logger("Exception while setting column widths. Choosing default.");
                cm.getColumn(i).setPreferredWidth(GUIGlobals.DEFAULT_FIELD_LENGTH);
            }
        }
    }

    public JScrollPane getPane() {
        return this.sp;
    }

    public void setShowingSearchResults(boolean search2, boolean group) {
        this.showingSearchResults = search2;
        this.showingGroup = group;
    }

    public void setRightClickMenu(JPopupMenu rcm) {
        this.rightClickMenu = rcm;
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        int status;
        int score = -3;
        try {
            status = this.tableModel.getCellStatus(row, column);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            Globals.logger("Error happened in getCellRenderer method of EntryTable, for cell (" + row + "," + column + ").");
            return this.defRenderer;
        }
        if (this.tableModel.hasField(row, "__markedentry")) {
            return this.markedRenderer;
        }
        if (!this.showingSearchResults || this.tableModel.nonZeroField(row, "__search")) {
            ++score;
        }
        if (!this.showingGroup || this.tableModel.nonZeroField(row, "__groupsearch")) {
            score += 2;
        }
        Renderer renderer = score < -1 ? this.veryGrayedOutRenderer : (score == -1 ? this.grayedOutRenderer : (!this.prefs.getBoolean("tableColorCodesOn") ? this.defRenderer : (column == 0 ? (this.tableModel.isComplete(row) ? this.defRenderer : (this.tableModel.hasCrossRef(row) ? this.maybeIncRenderer : this.incRenderer)) : (status == 1 ? this.reqRenderer : (status == 2 ? this.optRenderer : this.defRenderer)))));
        return renderer;
    }

    public void scrollTo(int y) {
        JScrollBar scb = this.sp.getVerticalScrollBar();
        scb.setValue(y * scb.getUnitIncrement(1));
    }

    public BibtexEntry[] getSelectedEntries() {
        BibtexEntry[] bes = null;
        int[] rows = this.getSelectedRows();
        if (rows.length > 0) {
            bes = new BibtexEntry[rows.length];
            for (int i = 0; i < rows.length; ++i) {
                bes[i] = this.tableModel.db.getEntryById(this.tableModel.getNameFromNumber(rows[i]));
            }
        }
        return bes;
    }

    public void ensureVisible(int row) {
        JScrollBar vert = this.sp.getVerticalScrollBar();
        int y = row * this.getRowHeight();
        if (y < vert.getValue() || y > vert.getValue() + vert.getVisibleAmount()) {
            this.scrollToCenter(row, 1);
        }
    }

    public void scrollToCenter(int rowIndex, int vColIndex) {
        if (!(this.getParent() instanceof JViewport)) {
            return;
        }
        JViewport viewport = (JViewport)this.getParent();
        Rectangle rect = this.getCellRect(rowIndex, vColIndex, true);
        Rectangle viewRect = viewport.getViewRect();
        rect.setLocation(rect.x - viewRect.x, rect.y - viewRect.y);
        int centerX = (viewRect.width - rect.width) / 2;
        int centerY = (viewRect.height - rect.height) / 2;
        if (rect.x < centerX) {
            centerX = -centerX;
        }
        if (rect.y < centerY) {
            centerY = -centerY;
        }
        rect.translate(centerX, centerY);
        viewport.scrollRectToVisible(rect);
        this.revalidate();
        this.repaint();
    }

    public void updateFont() {
        this.setFont(GUIGlobals.CURRENTFONT);
        this.setRowHeight(4 + GUIGlobals.CURRENTFONT.getSize());
    }

    private class Renderer
    extends DefaultTableCellRenderer {
        public Renderer(Color c) {
            this.setBackground(c);
        }

        public Renderer(Color c, Color fg) {
            this(c);
            this.setForeground(fg);
        }

        @Override
        protected void setValue(Object value) {
            if (value instanceof Icon) {
                this.setIcon((Icon)value);
                super.setValue(null);
            } else {
                this.setIcon(null);
                super.setValue(value);
            }
        }

        @Override
        public void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            if (EntryTable.this.antialiasing) {
                RenderingHints rh = g2.getRenderingHints();
                rh.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                rh.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                g2.setRenderingHints(rh);
            }
            super.paintComponent(g2);
        }
    }

    class TableClickListener
    extends MouseAdapter {
        TableClickListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int col = EntryTable.this.columnAtPoint(e.getPoint());
            if (col == 0 && e.getClickCount() == 2) {
                try {
                    EntryTable.this.panel.runCommand("edit");
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
            }
            if (e.getButton() == 3 || EntryTable.this.ctrlClick && e.getButton() == 1 && e.isControlDown()) {
                EntryTable.this.rightClickMenu = new RightClickMenu(EntryTable.this.panel, ((EntryTable)EntryTable.this).panel.metaData);
                EntryTable.this.rightClickMenu.show(EntryTable.this.ths, e.getX(), e.getY());
            }
            if (EntryTable.this.tableModel.getCellStatus(0, col) == 8) {
                final int row = EntryTable.this.rowAtPoint(e.getPoint());
                Object value = EntryTable.this.getValueAt(row, col);
                if (value == null) {
                    return;
                }
                final String[] iconType = EntryTable.this.tableModel.getIconTypeForColumn(col);
                int hasField = -1;
                for (int i = iconType.length - 1; i >= 0; --i) {
                    if (!EntryTable.this.tableModel.hasField(row, iconType[i])) continue;
                    hasField = i;
                }
                if (hasField == -1) {
                    return;
                }
                final String fieldName = iconType[hasField];
                new Thread(){

                    @Override
                    public void run() {
                        EntryTable.this.panel.output(Globals.lang("External viewer called") + ".");
                        BibtexEntry be = EntryTable.this.panel.database().getEntryById(EntryTable.this.tableModel.getNameFromNumber(row));
                        if (be == null) {
                            Globals.logger("Error: could not find entry.");
                            return;
                        }
                        Object link = be.getField(fieldName);
                        if (iconType == null) {
                            Globals.logger("Error: no link to " + fieldName + ".");
                            return;
                        }
                        try {
                            Util.openExternalViewer((String)link, fieldName, EntryTable.this.prefs);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }.start();
            }
        }
    }
}

