/*
 * Decompiled with CFR 0.152.
 */
package jabref;

import jabref.BasePanel;
import jabref.BibtexDatabase;
import jabref.BibtexEntry;
import jabref.EntryTableModel;
import jabref.Globals;
import jabref.SearchRuleSet;
import java.util.Enumeration;
import java.util.Hashtable;

public class DatabaseSearch
extends Thread {
    BasePanel panel = null;
    BibtexDatabase thisDatabase = null;
    SearchRuleSet thisRuleSet = null;
    Hashtable thisSearchOptions = null;
    EntryTableModel thisTableModel = null;
    String searchValueField = null;
    boolean reorder;

    public DatabaseSearch(Hashtable searchOptions, SearchRuleSet searchRules, BasePanel panel, String searchValueField, boolean reorder) {
        this.panel = panel;
        this.thisDatabase = panel.getDatabase();
        this.thisTableModel = panel.getTableModel();
        this.thisSearchOptions = searchOptions;
        this.thisRuleSet = searchRules;
        this.searchValueField = searchValueField;
        this.reorder = reorder;
    }

    @Override
    public void run() {
        String searchString = null;
        Enumeration strings = this.thisSearchOptions.elements();
        searchString = (String)strings.nextElement();
        int searchScore = 0;
        BibtexEntry bes = null;
        int numRows = this.thisDatabase.getEntryCount();
        int hits = 0;
        for (int row = 0; row < numRows; ++row) {
            bes = this.thisDatabase.getEntryById(this.thisTableModel.getNameFromNumber(row));
            searchScore = this.thisRuleSet.applyRules(this.thisSearchOptions, bes);
            bes.setField(this.searchValueField, String.valueOf(searchScore));
            if (searchScore <= 0) continue;
            ++hits;
        }
        if (this.reorder) {
            this.panel.showSearchResults(this.searchValueField);
        } else {
            this.panel.selectSearchResults();
        }
        if (this.searchValueField == null || this.searchValueField == "__search") {
            this.panel.output(Globals.lang("Searched database. Global number of hits") + ": " + hits);
        }
    }
}

