/*
 * Decompiled with CFR 0.152.
 */
package jabref;

import jabref.BibtexEntry;
import jabref.BibtexString;
import jabref.EntrySorter;
import jabref.Globals;
import jabref.KeyCollisionException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.JOptionPane;

public class BibtexDatabase {
    Map _entries = new HashMap();
    String _preamble = null;
    Vector _strings = new Vector();
    Hashtable _autoCompleters = null;
    private HashMap allKeys = new HashMap();
    private final VetoableChangeListener listener = new VetoableChangeListener(){

        @Override
        public void vetoableChange(PropertyChangeEvent pce) throws PropertyVetoException {
            if ("id".equals(pce.getPropertyName())) {
                Object oldEntry = BibtexDatabase.this._entries.remove((String)pce.getOldValue());
                if (oldEntry != pce.getSource()) {
                    BibtexDatabase.this._entries.put(pce.getOldValue(), oldEntry);
                    throw new PropertyVetoException("Wrong old ID", pce);
                }
                if (BibtexDatabase.this._entries.get(pce.getNewValue()) != null) {
                    BibtexDatabase.this._entries.put(pce.getOldValue(), oldEntry);
                    throw new PropertyVetoException("New ID already in use, please choose another", pce);
                }
                BibtexDatabase.this._entries.put((String)pce.getNewValue(), (BibtexEntry)pce.getSource());
            }
        }
    };

    public synchronized int getEntryCount() {
        return this._entries.size();
    }

    public synchronized Set getKeySet() {
        return this._entries.keySet();
    }

    public synchronized EntrySorter getSorter(Comparator comp) {
        return new EntrySorter(this._entries, comp);
    }

    public synchronized BibtexEntry getEntryById(String id) {
        return (BibtexEntry)this._entries.get(id);
    }

    public synchronized boolean insertEntry(BibtexEntry entry) throws KeyCollisionException {
        String id = entry.getId();
        if (this.getEntryById(id) != null) {
            throw new KeyCollisionException("ID is already in use, please choose another");
        }
        entry.addPropertyChangeListener(this.listener);
        this._entries.put(id, entry);
        return this.checkForDuplicateKeyAndAdd(null, entry.getCiteKey(), false);
    }

    public synchronized BibtexEntry removeEntry(String id) {
        BibtexEntry oldValue = (BibtexEntry)this._entries.remove(id);
        this.removeKeyFromSet(oldValue.getCiteKey());
        if (oldValue != null) {
            oldValue.removePropertyChangeListener(this.listener);
        }
        return oldValue;
    }

    public synchronized boolean setCiteKeyForEntry(String id, String key) {
        if (!this._entries.containsKey(id)) {
            return false;
        }
        BibtexEntry entry = this.getEntryById(id);
        String oldKey = entry.getCiteKey();
        entry.setField("bibtexkey", key);
        return this.checkForDuplicateKeyAndAdd(oldKey, entry.getCiteKey(), false);
    }

    public synchronized void setPreamble(String preamble) {
        this._preamble = preamble;
    }

    public synchronized String getPreamble() {
        return this._preamble;
    }

    public synchronized void addString(BibtexString string, int index) throws KeyCollisionException {
        Iterator i = this._strings.iterator();
        while (i.hasNext()) {
            if (!((BibtexString)i.next()).getName().equals(string.getName())) continue;
            throw new KeyCollisionException("A string with this label already exists,");
        }
        this._strings.insertElementAt(string, index);
    }

    public synchronized void removeString(int index) {
        this._strings.removeElementAt(index);
    }

    public synchronized BibtexString getString(int index) {
        return (BibtexString)this._strings.elementAt(index);
    }

    public synchronized int getStringCount() {
        return this._strings.size();
    }

    public synchronized boolean hasStringLabel(String label) {
        Iterator i = this._strings.iterator();
        while (i.hasNext()) {
            if (!((BibtexString)i.next()).getName().equals(label)) continue;
            return true;
        }
        return false;
    }

    public boolean checkForDuplicateKeyAndAdd(String oldKey, String newKey, boolean issueWarning) {
        boolean duplicate = false;
        if (oldKey == null) {
            duplicate = this.addKeyToSet(newKey);
        } else if (oldKey.equals(newKey)) {
            duplicate = false;
        } else {
            this.removeKeyFromSet(oldKey);
            duplicate = this.addKeyToSet(newKey);
        }
        if (duplicate && issueWarning) {
            JOptionPane.showMessageDialog(null, Globals.lang("Warning there is a duplicate key") + ":" + newKey, Globals.lang("Duplicate Key Warning"), 2);
        }
        return duplicate;
    }

    private boolean addKeyToSet(String key) {
        boolean exists = false;
        if (key == null || key.equals("")) {
            return false;
        }
        if (this.allKeys.containsKey(key)) {
            exists = true;
            this.allKeys.put(key, new Integer((Integer)this.allKeys.get(key) + 1));
        } else {
            this.allKeys.put(key, new Integer(1));
        }
        return exists;
    }

    private void removeKeyFromSet(String key) {
        if (key == null || key.equals("")) {
            return;
        }
        if (this.allKeys.containsKey(key)) {
            Integer tI = (Integer)this.allKeys.get(key);
            if (tI == 1) {
                this.allKeys.remove(key);
            } else {
                this.allKeys.put(key, new Integer(tI - 1));
            }
        }
    }
}

