/*
 * Decompiled with CFR 0.152.
 */
package dragmath;

import dragmath.AddComponent;
import dragmath.MseSelectListener;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class MseMotionSelectListener
extends MouseMotionAdapter {
    private JPanel jPanelWorkspace;
    private MseSelectListener mouseListener;

    public MseMotionSelectListener(JPanel jPanelWorkspace, MseSelectListener mouseListener) {
        this.jPanelWorkspace = jPanelWorkspace;
        this.mouseListener = mouseListener;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        Point xy2 = new Point(e.getX(), e.getY());
        MseSelectListener.deSelect((JPanel)e.getSource());
        this.highlight((JPanel)e.getSource(), xy2, false);
        this.jPanelWorkspace.requestFocus();
    }

    public void highlight(JPanel layer, Point xy2, boolean nested) {
        Component[] components = layer.getComponents();
        Point c_xy = null;
        double x = 0.0;
        double y = 0.0;
        for (int i = 0; i < components.length; ++i) {
            if (!nested) {
                c_xy = components[i].getLocation();
                SwingUtilities.convertPointToScreen(c_xy, components[i].getParent());
                SwingUtilities.convertPointFromScreen(c_xy, this.jPanelWorkspace);
                x = components[i].getWidth();
                y = components[i].getHeight();
            }
            if (nested || (c_xy.getX() > this.mouseListener.getXy1().getX() && c_xy.getX() < xy2.getX() || c_xy.getX() + x > this.mouseListener.getXy1().getX() && c_xy.getX() + x < xy2.getX()) && (c_xy.getY() > this.mouseListener.getXy1().getY() && c_xy.getY() < xy2.getY() || c_xy.getY() + y > this.mouseListener.getXy1().getY() && c_xy.getY() + y < xy2.getY() || this.mouseListener.getXy1().getY() > c_xy.getY() && xy2.getY() < c_xy.getY() + y)) {
                JPanel temp;
                JLabel temp2;
                if (components[i].getClass().getName().equals("javax.swing.JLabel") && (AddComponent.getGroup((temp2 = (JLabel)components[i]).getName()) == 1 || AddComponent.getGroup(temp2.getName()) == 2)) {
                    temp2.setOpaque(true);
                    components[i].setBackground(MseSelectListener.SELECT);
                }
                if (components[i].getClass().getName().equals("dragmath.TextBox")) {
                    components[i].setBackground(MseSelectListener.SELECT);
                }
                if (components[i].getClass().getName().equals("javax.swing.JPanel")) {
                    components[i].setBackground(MseSelectListener.SELECT);
                    this.highlight((JPanel)components[i], xy2, true);
                }
                boolean all = true;
                for (int j = 0; j < components.length && all; ++j) {
                    if (components[j].getBackground().equals(MseSelectListener.SELECT) || AddComponent.getID(layer.getName()) == 8 && j == 2 || AddComponent.getID(layer.getName()) == 6 && j == 0 || AddComponent.getID(layer.getName()) == 6 && j == 1 || AddComponent.getID(layer.getName()) == 1 && j == 1) continue;
                    all = false;
                }
                if (all && (temp = (JPanel)components[i].getParent()) != this.jPanelWorkspace) {
                    temp.setBackground(MseSelectListener.SELECT);
                }
            }
            if (!components[i].getClass().getName().equals("javax.swing.JPanel")) continue;
            this.highlight((JPanel)components[i], xy2, nested);
        }
    }

    public void clickSelect(JComponent component) {
        MseSelectListener.deSelect(this.jPanelWorkspace);
        if (component.getClass().getName().equals("javax.swing.JLabel")) {
            JLabel temp = (JLabel)component;
            if (AddComponent.getGroup(temp.getName()) == 1 || AddComponent.getGroup(temp.getName()) == 2) {
                temp.setOpaque(true);
                component.setBackground(MseSelectListener.SELECT);
            } else {
                component.getParent().setBackground(MseSelectListener.SELECT);
                this.highlightNested((JPanel)component.getParent());
            }
        }
        if (component.getClass().getName().equals("dragmath.TextBox")) {
            component.setBackground(MseSelectListener.SELECT);
        }
        if (component.getClass().getName().equals("javax.swing.JPanel") && component != this.jPanelWorkspace) {
            component.setBackground(MseSelectListener.SELECT);
            this.highlightNested((JPanel)component);
        }
    }

    public void highlightNested(JPanel layer) {
        Component[] components = layer.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (components[i].getClass().getName().equals("javax.swing.JLabel")) {
                JLabel temp = (JLabel)components[i];
                temp.setOpaque(true);
                components[i].setBackground(MseSelectListener.SELECT);
            }
            if (components[i].getClass().getName().equals("dragmath.TextBox")) {
                components[i].setBackground(MseSelectListener.SELECT);
            }
            if (!components[i].getClass().getName().equals("javax.swing.JPanel")) continue;
            components[i].setBackground(MseSelectListener.SELECT);
            this.highlightNested((JPanel)components[i]);
        }
    }
}

