/*
 * Decompiled with CFR 0.152.
 */
package com.vlsolutions.swing.table;

import com.vlsolutions.swing.table.VLJTable;
import com.vlsolutions.swing.table.VLJTableFilter;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class FilterModel
extends AbstractTableModel
implements TableModelListener {
    public static final int SORT_NONE = 0;
    public static final int SORT_ASCENDING = 1;
    public static final int SORT_DESCENDING = 2;
    protected int[] filterIndex = new int[0];
    protected VLJTableFilter[] filters;
    protected int[] sortModes;
    protected int[] indexes;
    protected TableModel model;
    protected VLJTable table;

    public FilterModel(VLJTable table, TableModel model) {
        this.table = table;
        this.model = model;
        this.filters = new VLJTableFilter[model.getColumnCount()];
        this.sortModes = new int[model.getColumnCount()];
        this.rebuildIndex();
        model.addTableModelListener(this);
    }

    public TableModel getModel() {
        return this.model;
    }

    public void clearFilters() {
        int cols = this.model.getColumnCount();
        for (int i = 0; i < cols; ++i) {
            if (this.filters[i] == null) continue;
            this.filters[i].setFilter(null);
        }
        this.rebuildIndex();
    }

    public int getSourceRow(int row) {
        return this.filterIndex[this.indexes[row]];
    }

    public void setFilter(int col, Object value) {
        this.filters[col].setFilter(value);
        this.rebuildIndex();
    }

    public void installFilter(int col, VLJTableFilter filter) {
        this.filters[col] = filter;
        this.rebuildIndex();
    }

    public VLJTableFilter getFilter(int col) {
        return this.filters[col];
    }

    @Override
    public int getColumnCount() {
        return this.model.getColumnCount();
    }

    @Override
    public String getColumnName(int col) {
        return this.model.getColumnName(col);
    }

    public Class getColumnClass(int col) {
        return this.model.getColumnClass(col);
    }

    @Override
    public int getRowCount() {
        return this.filterIndex.length;
    }

    @Override
    public Object getValueAt(int row, int col) {
        return this.model.getValueAt(this.filterIndex[this.indexes[row]], col);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return this.model.isCellEditable(this.filterIndex[this.indexes[row]], col);
    }

    @Override
    public void setValueAt(Object o, int row, int col) {
        this.model.setValueAt(o, this.filterIndex[this.indexes[row]], col);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tableChanged(TableModelEvent e) {
        boolean sortOrFilter = this.isSortedOrFiltered();
        FilterModel filterModel = this;
        synchronized (filterModel) {
            if (e.getFirstRow() == -1) {
                this.filters = new VLJTableFilter[this.model.getColumnCount()];
                this.sortModes = new int[this.model.getColumnCount()];
                this.rebuildIndex();
                this.fireTableStructureChanged();
            } else if (sortOrFilter) {
                this.rebuildIndex();
            } else if (e.getLastRow() > this.indexes.length) {
                this.indexes = new int[this.model.getRowCount()];
                this.filterIndex = new int[this.model.getRowCount()];
                for (int i = 0; i < this.indexes.length; ++i) {
                    this.indexes[i] = this.filterIndex[i] = i;
                }
                this.fireTableChanged(new TableModelEvent(this, e.getFirstRow(), e.getLastRow(), e.getColumn(), e.getType()));
            }
        }
    }

    public void rebuildIndex() {
        int i;
        boolean existFilter = false;
        for (i = 0; i < this.model.getColumnCount(); ++i) {
            if (this.filters[i] == null) continue;
            existFilter = true;
        }
        if (existFilter) {
            int i2;
            int rowCount = this.model.getRowCount();
            int colCount = this.model.getColumnCount();
            for (int j = 0; j < colCount; ++j) {
                if (this.filters[j] == null) continue;
                this.filters[j].compile();
            }
            ArrayList<Integer> dataIndex = new ArrayList<Integer>(this.model.getRowCount() / 2);
            for (i2 = 0; i2 < rowCount; ++i2) {
                boolean reject = false;
                for (int j = 0; j < colCount && !reject; ++j) {
                    VLJTableFilter filter = this.filters[j];
                    if (filter == null) continue;
                    Object o = this.model.getValueAt(i2, j);
                    if (filter.accept(this.model.getValueAt(i2, j))) continue;
                    reject = true;
                }
                if (reject) continue;
                dataIndex.add(new Integer(i2));
            }
            this.filterIndex = new int[dataIndex.size()];
            for (i2 = 0; i2 < dataIndex.size(); ++i2) {
                this.filterIndex[i2] = (Integer)dataIndex.get(i2);
            }
        } else {
            this.filterIndex = new int[this.model.getRowCount()];
            for (i = 0; i < this.filterIndex.length; ++i) {
                this.filterIndex[i] = i;
            }
        }
        this.reallocateIndexes();
        this.sort();
        this.fireTableDataChanged();
    }

    protected boolean isSortedOrFiltered() {
        int i;
        if (!this.table.isSortEnabled() && !this.table.isFilteringEnabled()) {
            return false;
        }
        boolean rep = false;
        for (i = 0; i < this.sortModes.length && !rep; ++i) {
            rep = this.sortModes[i] != 0;
        }
        for (i = 0; i < this.filters.length && !rep; ++i) {
            rep = this.filters[i] != null;
        }
        return rep;
    }

    protected int getSortMode(int col) {
        return this.sortModes[col];
    }

    protected void setSortMode(int col, int mode) {
        this.sortModes[col] = mode;
        this.rebuildIndex();
    }

    private int compareRowsByColumn(int row1, int row2, int column) {
        String s2;
        TableModel data = this.model;
        Class type = this.getColumnClass(column);
        Object o1 = data.getValueAt(row1, column);
        Object o2 = data.getValueAt(row2, column);
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        if (type.getSuperclass() == Number.class) {
            Number n2;
            double d2;
            Number n1 = (Number)o1;
            double d1 = n1.doubleValue();
            if (d1 < (d2 = (n2 = (Number)o2).doubleValue())) {
                return -1;
            }
            if (d1 > d2) {
                return 1;
            }
            return 0;
        }
        if (type == Date.class) {
            Date d2;
            long n2;
            Date d1 = (Date)o1;
            long n1 = d1.getTime();
            if (n1 < (n2 = (d2 = (Date)o2).getTime())) {
                return -1;
            }
            if (n1 > n2) {
                return 1;
            }
            return 0;
        }
        if (type == String.class) {
            String s1 = (String)o1;
            String s22 = (String)o2;
            int result = s1.compareTo(s22);
            if (result < 0) {
                return -1;
            }
            if (result > 0) {
                return 1;
            }
            return 0;
        }
        if (type == Boolean.class) {
            Boolean bool2;
            boolean b2;
            Boolean bool1 = (Boolean)o1;
            boolean b1 = bool1;
            if (b1 == (b2 = (bool2 = (Boolean)o2).booleanValue())) {
                return 0;
            }
            if (b1) {
                return 1;
            }
            return -1;
        }
        String s1 = o1.toString();
        int result = s1.compareTo(s2 = o2.toString());
        if (result < 0) {
            return -1;
        }
        if (result > 0) {
            return 1;
        }
        return 0;
    }

    private int compare(int row1, int row2) {
        for (int i = 0; i < this.sortModes.length; ++i) {
            int result;
            int sortMode = this.sortModes[i];
            if (sortMode == 0 || (result = this.compareRowsByColumn(this.filterIndex[row1], this.filterIndex[row2], i)) == 0) continue;
            return sortMode == 1 ? result : -result;
        }
        return 0;
    }

    private void reallocateIndexes() {
        int rowCount = this.filterIndex.length;
        this.indexes = new int[rowCount];
        for (int row = 0; row < rowCount; ++row) {
            this.indexes[row] = row;
        }
    }

    private void checkModel() {
        if (this.indexes.length != this.filterIndex.length) {
            throw new RuntimeException("Model changed");
        }
    }

    private void sort() {
        this.checkModel();
        this.shuttleSort((int[])this.indexes.clone(), this.indexes, 0, this.indexes.length);
    }

    private void n2sort() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            for (int j = i + 1; j < this.getRowCount(); ++j) {
                if (this.compare(this.indexes[i], this.indexes[j]) != -1) continue;
                this.swap(i, j);
            }
        }
    }

    private void shuttleSort(int[] from, int[] to, int low, int high) {
        if (high - low < 2) {
            return;
        }
        int middle = (low + high) / 2;
        this.shuttleSort(to, from, low, middle);
        this.shuttleSort(to, from, middle, high);
        int p = low;
        int q = middle;
        if (high - low >= 4 && this.compare(from[middle - 1], from[middle]) <= 0) {
            for (int i = low; i < high; ++i) {
                to[i] = from[i];
            }
            return;
        }
        for (int i = low; i < high; ++i) {
            to[i] = q >= high || p < middle && this.compare(from[p], from[q]) <= 0 ? from[p++] : from[q++];
        }
    }

    private void swap(int i, int j) {
        int tmp = this.indexes[i];
        this.indexes[i] = this.indexes[j];
        this.indexes[j] = tmp;
    }
}

