/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.jyconsole.ui;

import com.artenum.tk.ui.ToolBox;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jehep.shelljython.JyShell;

public class PreferenceDialog
extends JDialog
implements ActionListener {
    public static final String OK = "ok";
    public static final String CANCEL = "cancel";
    public static final String BROWSE = "browse";
    public static final String COLOR_DEFAULT = "color.default";
    public static final String COLOR_ERROR = "color.error";
    public static final String COLOR_BG = "color.bg";
    private JyShell console;
    private JTextField scriptDir;
    private JButton browse;
    private JButton bgColor;
    private JButton defaultTxtColor;
    private JCheckBox defaultItalic;
    private JCheckBox defaultBold;
    private JButton errorTxtColor;
    private JCheckBox errorItalic;
    private JCheckBox errorBold;
    private JButton ok;
    private JButton cancel;

    public PreferenceDialog(JyShell console) {
        super(ToolBox.getParentFrame(console));
        this.console = console;
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 3));
        JPanel panel = new JPanel(new GridLayout(3, 4));
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK, 1), "Style"));
        this.bgColor = new JButton();
        this.bgColor.setBackground(Color.WHITE);
        this.bgColor.setActionCommand(COLOR_BG);
        this.bgColor.addActionListener(this);
        this.defaultBold = new JCheckBox("Bold");
        this.defaultItalic = new JCheckBox("Italic");
        this.defaultTxtColor = new JButton();
        this.defaultTxtColor.setBackground(Color.BLACK);
        this.defaultTxtColor.setActionCommand(COLOR_DEFAULT);
        this.defaultTxtColor.addActionListener(this);
        this.errorBold = new JCheckBox("Bold");
        this.errorItalic = new JCheckBox("Italic");
        this.errorTxtColor = new JButton();
        this.errorTxtColor.setBackground(Color.RED);
        this.errorTxtColor.setActionCommand(COLOR_ERROR);
        this.errorTxtColor.addActionListener(this);
        panel.add(new JLabel("Default"));
        panel.add(this.defaultTxtColor);
        panel.add(this.defaultBold);
        panel.add(this.defaultItalic);
        panel.add(new JLabel("Error"));
        panel.add(this.errorTxtColor);
        panel.add(this.errorBold);
        panel.add(this.errorItalic);
        panel.add(new JLabel("Bg color"));
        panel.add(this.bgColor);
        this.getContentPane().add(panel);
        panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK, 1), "Script base directory"));
        this.scriptDir = new JTextField();
        if (console.getPreferences().get("jyconsole.pref.script.dir") != null) {
            this.scriptDir.setText((String)console.getPreferences().get("jyconsole.pref.script.dir"));
        }
        this.browse = new JButton("Browse");
        this.browse.setActionCommand(BROWSE);
        this.browse.addActionListener(this);
        panel.add((Component)this.scriptDir, "Center");
        panel.add((Component)this.browse, "East");
        panel.setMaximumSize(new Dimension(10000, this.scriptDir.getHeight()));
        this.getContentPane().add(panel);
        panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 2));
        this.ok = new JButton("Ok");
        this.ok.setActionCommand(OK);
        this.ok.addActionListener(this);
        this.cancel = new JButton("Cancel");
        this.cancel.setActionCommand(CANCEL);
        this.cancel.addActionListener(this);
        panel.add(Box.createHorizontalGlue());
        panel.add(this.ok);
        panel.add(this.cancel);
        this.getContentPane().add(panel);
        this.pack();
        this.setLocationRelativeTo(console);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals(OK)) {
            this.console.getPreferences().put("jyconsole.pref.bg.color", this.bgColor.getBackground());
            this.console.getPreferences().put("jyconsole.pref.txt.color.error", this.errorTxtColor.getBackground());
            this.console.getPreferences().put("jyconsole.pref.txt.color.normal", this.defaultTxtColor.getBackground());
            this.console.getPreferences().put("jyconsole.pref.script.dir", this.scriptDir.getText());
            this.console.savePreferences();
            this.console.setColor(this.defaultTxtColor.getBackground(), this.bgColor.getBackground());
            this.console.setBoldToStyle("default", this.defaultBold.isSelected());
            this.console.setItalicToStyle("default", this.defaultItalic.isSelected());
            this.console.setColorToStyle("error", this.errorTxtColor.getBackground());
            this.console.setBoldToStyle("error", this.errorBold.isSelected());
            this.console.setItalicToStyle("error", this.errorItalic.isSelected());
            File dir2 = new File(this.scriptDir.getText());
            if (dir2.exists()) {
                this.console.getPreferences().put("jyconsole.pref.script.dir", dir2.getAbsolutePath());
            }
        } else if (command.equals(CANCEL)) {
            this.dispose();
        } else if (command.equals(BROWSE)) {
            JFileChooser chooser = new JFileChooser((String)this.console.getPreferences().get("jyconsole.pref.script.dir"));
            chooser.setFileSelectionMode(1);
            chooser.setMultiSelectionEnabled(false);
            if (chooser.showOpenDialog(this.console) == 0) {
                File dir3 = chooser.getSelectedFile();
                this.scriptDir.setText(dir3.getAbsolutePath());
            }
        } else if (command.equals(COLOR_BG)) {
            String title = "Choose background color";
            Color currentColor = this.bgColor.getBackground();
            Color result = JColorChooser.showDialog(this, title, currentColor);
            if (result != null) {
                this.bgColor.setBackground(result);
            }
        } else if (command.equals(COLOR_DEFAULT) || command.equals(COLOR_ERROR)) {
            Color currentColor = null;
            String title = "Choose text color for style: ";
            if (command.equals(COLOR_DEFAULT)) {
                currentColor = this.defaultTxtColor.getBackground();
                title = title + "Default";
            } else {
                currentColor = this.errorTxtColor.getBackground();
                title = title + "Error";
            }
            Color result = JColorChooser.showDialog(this, title, currentColor);
            if (result == null) {
                return;
            }
            if (command.equals(COLOR_DEFAULT)) {
                this.defaultTxtColor.setBackground(result);
            } else {
                this.errorTxtColor.setBackground(result);
            }
        }
    }
}

