/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.jyconsole.command;

import com.artenum.jyconsole.python.JInteractiveInterpreter;
import java.io.File;
import javax.swing.JOptionPane;
import jehep.ui.Editor;
import jehep.ui.SetEnv;
import org.python.core.PyException;

public class Command
implements Runnable {
    private JInteractiveInterpreter pythonInterpreter;
    private File commandFile;
    private String command;
    private boolean isRunning = false;
    private Thread myThread;

    public Command(JInteractiveInterpreter pythonInterpreter, File commandFile) {
        this.pythonInterpreter = pythonInterpreter;
        this.commandFile = commandFile;
    }

    public Command(JInteractiveInterpreter pythonInterpreter, String command) {
        this.pythonInterpreter = pythonInterpreter;
        this.command = command;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Command command = this;
        synchronized (command) {
            if (this.isRunning()) {
                this.myThread.interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Command command;
        try {
            String serror;
            command = this;
            synchronized (command) {
                this.isRunning = true;
                this.myThread = Thread.currentThread();
            }
            if (SetEnv.ClassPath != null && this.commandFile != null) {
                Editor.ErrorLine = -1;
                try {
                    this.pythonInterpreter.execfile(this.commandFile.getAbsolutePath());
                }
                catch (PyException e) {
                    serror = e.toString();
                    Editor.findErrorLine(serror);
                    serror = serror.replace("\"", "");
                    serror = serror.replace("\n", " , ");
                    serror = serror.replace("'", "");
                    this.pythonInterpreter.exec("print '" + serror + "'");
                }
            }
            if (SetEnv.ClassPath == null && this.commandFile != null) {
                try {
                    this.pythonInterpreter.execfile(this.commandFile.getAbsolutePath());
                }
                catch (PyException e) {
                    serror = e.toString();
                    this.ErrorMessage(serror);
                }
            }
            if (this.command != null) {
                this.pythonInterpreter.runsource(this.command);
            }
        }
        finally {
            command = this;
            synchronized (command) {
                this.isRunning = false;
                this.notifyAll();
            }
        }
    }

    public String toString() {
        if (this.commandFile != null) {
            return this.commandFile.getAbsolutePath();
        }
        return this.command;
    }

    private void ErrorMessage(String a) {
        JOptionPane dialogError = new JOptionPane();
        JOptionPane.showMessageDialog(dialogError, a, "Error", 0);
    }
}

