/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.jyconsole;

import java.util.ArrayList;
import jehep.shelljython.JyShell;

public class HistoryManager {
    private JyShell console;
    private ArrayList history;
    private int historyIndex;
    private boolean inHistory;

    public HistoryManager(JyShell console) {
        this.console = console;
        this.history = new ArrayList();
    }

    public void addCommandInHistory(String command) {
        this.stopHistoryNavigation();
        this.history.remove(command);
        this.history.add(command);
    }

    public void showPreviousCommand() {
        if (!this.inHistory) {
            this.startHistoryNavigation();
        }
        --this.historyIndex;
        if (this.isInRange()) {
            this.console.getInteractiveCommandLine().reset();
            this.console.getInteractiveCommandLine().append((String)this.history.get(this.historyIndex));
        } else {
            ++this.historyIndex;
        }
    }

    public void showNextCommand() {
        if (!this.inHistory) {
            return;
        }
        ++this.historyIndex;
        if (this.isInRange()) {
            this.console.getInteractiveCommandLine().reset();
            this.console.getInteractiveCommandLine().append((String)this.history.get(this.historyIndex));
        } else {
            --this.historyIndex;
        }
    }

    public void startHistoryNavigation() {
        this.inHistory = true;
        this.history.add(this.console.getInteractiveCommandLine().getCmdLine());
        this.historyIndex = this.history.size() - 1;
    }

    public void stopHistoryNavigation() {
        if (!this.inHistory) {
            return;
        }
        this.inHistory = false;
        if (this.history.size() > 0 && ((String)this.history.get(this.history.size() - 1)).trim().length() == 0) {
            this.history.remove(this.history.size() - 1);
        }
    }

    public boolean isInHistory() {
        return this.inHistory;
    }

    public boolean isInRange() {
        return this.historyIndex >= 0 && this.historyIndex < this.history.size();
    }
}

