/*
 * Decompiled with CFR 0.152.
 */
package javolution.testing;

import javolution.context.Context;
import javolution.context.LogContext;
import javolution.context.ObjectFactory;
import javolution.lang.Configurable;
import javolution.lang.MathLib;
import javolution.testing.AssertionException;
import javolution.testing.TestCase;
import javolution.testing.TestContext;
import javolution.text.TextBuilder;

public abstract class TimeContext
extends TestContext {
    public static final Class<TimeContext> REGRESSION = Regression.access$000();
    public static final Configurable<Integer> TEST_DURATION_MS = new Configurable<Integer>(new Integer(1000));
    public static final Configurable<Class<? extends TimeContext>> DEFAULT = new Configurable<Class>(Default.access$100());
    private long _minimumPs;
    private long _averagePs;
    private long _maximumPs;
    private TestCase _testCase;

    public static TimeContext enter() {
        return Context.enter(DEFAULT.get());
    }

    public static TimeContext exit() {
        return (TimeContext)Context.exit();
    }

    public static long getMinimumTime(String string) {
        LogContext logContext = LogContext.getCurrent();
        if (logContext instanceof TimeContext) {
            return TimeContext.picosecondTo(string, ((TimeContext)logContext).getMinimumTimeInPicoSeconds());
        }
        return -1L;
    }

    public static long getAverageTime(String string) {
        LogContext logContext = LogContext.getCurrent();
        if (logContext instanceof TimeContext) {
            return TimeContext.picosecondTo(string, ((TimeContext)logContext).getAverageTimeInPicoSeconds());
        }
        return -1L;
    }

    public static long getMaximumTime(String string) {
        LogContext logContext = LogContext.getCurrent();
        if (logContext instanceof TimeContext) {
            return TimeContext.picosecondTo(string, ((TimeContext)logContext).getMaximumTimeInPicoSeconds());
        }
        return -1L;
    }

    private static long picosecondTo(String string, long l) {
        if (string.equals("ps")) {
            return l;
        }
        if (string.equals("ns")) {
            return l / 1000L;
        }
        if (string.equals("us")) {
            return l / 1000000L;
        }
        if (string.equals("ms")) {
            return l / 1000000000L;
        }
        if (string.equals("s")) {
            return l / 1000000000000L;
        }
        throw new IllegalArgumentException("Unit " + string + " not recognized");
    }

    public long getMinimumTimeInPicoSeconds() {
        return this._minimumPs;
    }

    public long getAverageTimeInPicoSeconds() {
        return this._averagePs;
    }

    public long getMaximumTimeInPicoSeconds() {
        return this._maximumPs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTest(TestCase testCase) {
        this._testCase = testCase;
        System.gc();
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this._minimumPs = Long.MAX_VALUE;
        this._maximumPs = 0L;
        this._averagePs = 0L;
        long l = 0L;
        long l2 = 0L;
        long l3 = (long)TEST_DURATION_MS.get().intValue() * 1000000000L;
        while (true) {
            testCase.prepare();
            try {
                long l4 = TimeContext.nanoTime();
                testCase.execute();
                long l5 = (TimeContext.nanoTime() - l4) * 1000L;
                int n = testCase.count();
                l += (long)n;
                l2 += l5;
                long l6 = l5 / (long)n;
                if (l6 < this._minimumPs) {
                    this._minimumPs = l6;
                }
                if (l6 > this._maximumPs) {
                    this._maximumPs = l6;
                }
                if (l2 < l3) continue;
                this._averagePs = l2 / l;
                testCase.validate();
            }
            finally {
                testCase.cleanup();
                continue;
            }
            break;
        }
    }

    public boolean doAssertEquals(String string, Object object, Object object2) {
        if (object == null && object2 != null || object != null && !object.equals(object2)) {
            LogContext.error(this._testCase.toString());
            throw new AssertionException(string, object, object2);
        }
        return true;
    }

    private static long nanoTime() {
        return System.nanoTime();
    }

    static {
        ObjectFactory.setInstance(new ObjectFactory(){

            protected Object create() {
                return new Default();
            }
        }, Default.CLASS);
        ObjectFactory.setInstance(new ObjectFactory(){

            protected Object create() {
                return new Regression();
            }
        }, Regression.CLASS);
    }

    private static final class Regression
    extends TimeContext {
        private static final Class CLASS = new Regression().getClass();

        private Regression() {
        }

        public boolean isErrorLogged() {
            return false;
        }

        public boolean isInfoLogged() {
            return false;
        }

        public boolean isWarningLogged() {
            return false;
        }

        public void logError(Throwable throwable, CharSequence charSequence) {
        }

        public void logInfo(CharSequence charSequence) {
        }

        public void logWarning(CharSequence charSequence) {
        }
    }

    private static final class Default
    extends TimeContext {
        private static final Class CLASS = new Default().getClass();

        private Default() {
        }

        public void doTest(TestCase testCase) {
            super.doTest(testCase);
            TextBuilder textBuilder = TextBuilder.newInstance();
            textBuilder.append("[test] ");
            textBuilder.append(testCase.toString());
            textBuilder.append(": ");
            Default.appendTime(this.getAverageTimeInPicoSeconds(), textBuilder);
            textBuilder.append(" (minimum ");
            Default.appendTime(this.getMinimumTimeInPicoSeconds(), textBuilder);
            textBuilder.append(")");
            textBuilder.println();
            TextBuilder.recycle(textBuilder);
        }

        private static TextBuilder appendTime(long l, TextBuilder textBuilder) {
            long l2;
            String string;
            if (l > 1000000000000L) {
                string = " s";
                l2 = 1000000000000L;
            } else if (l > 1000000000L) {
                string = " ms";
                l2 = 1000000000L;
            } else if (l > 1000000L) {
                string = " us";
                l2 = 1000000L;
            } else if (l > 1000L) {
                string = " ns";
                l2 = 1000L;
            } else {
                string = " ps";
                l2 = 1L;
            }
            long l3 = l / l2;
            textBuilder.append(l3);
            int n = 3 - MathLib.digitLength(l3);
            if (n > 0) {
                textBuilder.append(".");
            }
            int n2 = 0;
            int n3 = 10;
            while (n2 < n) {
                textBuilder.append(l * (long)n3 / l2 % 10L);
                ++n2;
                n3 *= 10;
            }
            return textBuilder.append(string);
        }

        public boolean isInfoLogged() {
            return true;
        }

        public void logInfo(CharSequence charSequence) {
            System.out.print("[info] ");
            System.out.println(charSequence);
        }

        public boolean isWarningLogged() {
            return true;
        }

        public void logWarning(CharSequence charSequence) {
            System.out.print("[warning] ");
            System.out.println(charSequence);
        }

        public boolean isErrorLogged() {
            return true;
        }

        public void logError(Throwable throwable, CharSequence charSequence) {
            System.out.print("[error] ");
            if (throwable != null) {
                System.out.print(throwable.getClass().getName());
                System.out.print(" - ");
            }
            String string = charSequence != null ? ((Object)charSequence).toString() : (throwable != null ? throwable.getMessage() : "");
            System.out.println(string);
            if (throwable != null) {
                throwable.printStackTrace();
            }
        }
    }
}

