/*
 * Decompiled with CFR 0.152.
 */
package javolution.testing;

import javolution.context.LogContext;
import javolution.context.ObjectFactory;
import javolution.testing.AssertionException;
import javolution.testing.TestCase;
import javolution.text.TextBuilder;

public abstract class TestContext
extends LogContext {
    public static final Class<TestContext> REGRESSION = Regression.access$000();
    private static final Boolean TRUE = new Boolean(true);
    private static final Boolean FALSE = new Boolean(false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void test(TestCase testCase) {
        LogContext logContext = LogContext.getCurrent();
        if (logContext instanceof TestContext) {
            ((TestContext)logContext).doTest(testCase);
        } else {
            if (logContext.isInfoLogged()) {
                logContext.logInfo(testCase.toString());
            }
            testCase.prepare();
            try {
                testCase.execute();
                testCase.validate();
            }
            finally {
                testCase.cleanup();
            }
        }
    }

    public static boolean assertEquals(String string, Object object, Object object2) {
        LogContext logContext = LogContext.getCurrent();
        if (logContext instanceof TestContext) {
            return ((TestContext)logContext).doAssertEquals(string, object, object2);
        }
        if (object == null && object2 != null || object != null && !object.equals(object2)) {
            if (logContext.isErrorLogged()) {
                TextBuilder textBuilder = TextBuilder.newInstance();
                if (string != null) {
                    textBuilder.append(string).append(": ");
                }
                textBuilder.append(object);
                textBuilder.append(" expected but found ");
                textBuilder.append(object2);
                logContext.logError(null, textBuilder);
                TextBuilder.recycle(textBuilder);
            }
            return false;
        }
        return true;
    }

    public static boolean assertEquals(Object object, Object object2) {
        return TestContext.assertEquals(null, object, object2);
    }

    public static boolean assertTrue(String string, boolean bl) {
        return TestContext.assertEquals(string, TRUE, bl ? TRUE : FALSE);
    }

    public static boolean assertTrue(boolean bl) {
        return TestContext.assertEquals(null, TRUE, bl ? TRUE : FALSE);
    }

    public abstract void doTest(TestCase var1);

    public abstract boolean doAssertEquals(String var1, Object var2, Object var3);

    static {
        ObjectFactory.setInstance(new ObjectFactory(){

            protected Object create() {
                return new Regression();
            }
        }, Regression.CLASS);
    }

    private static final class Regression
    extends TestContext {
        private static final Class CLASS = new Regression().getClass();

        private Regression() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doTest(TestCase testCase) {
            testCase.prepare();
            try {
                testCase.execute();
                testCase.validate();
            }
            finally {
                testCase.cleanup();
            }
        }

        public boolean doAssertEquals(String string, Object object, Object object2) {
            if (object == null && object2 != null || object != null && !object.equals(object2)) {
                throw new AssertionException(string, object, object2);
            }
            return true;
        }

        public boolean isErrorLogged() {
            return false;
        }

        public boolean isInfoLogged() {
            return false;
        }

        public boolean isWarningLogged() {
            return false;
        }

        public void logError(Throwable throwable, CharSequence charSequence) {
        }

        public void logInfo(CharSequence charSequence) {
        }

        public void logWarning(CharSequence charSequence) {
        }
    }
}

