/*
 * Decompiled with CFR 0.152.
 */
package math.jwave.types;

import math.jwave.datatypes.Complex;
import org.junit.Assert;
import org.junit.Test;

public class ComplexTest {
    @Test
    public void testGetReal() {
        Complex a = new Complex(1.0, 1.0);
        double real = a.getReal();
        Assert.assertEquals((double)1.0, (double)real, (double)0.0);
    }

    @Test
    public void testGetImag() {
        Complex a = new Complex(1.0, 1.0);
        double imag = a.getImag();
        Assert.assertEquals((double)1.0, (double)imag, (double)0.0);
    }

    @Test
    public void testGetMag() {
        double mag = 0.0;
        Complex a1 = new Complex(Math.sqrt(2.0), Math.sqrt(2.0));
        mag = a1.getMag();
        Assert.assertEquals((double)2.0, (double)mag, (double)0.0);
    }

    @Test
    public void testGetPhi() {
        double phi = 0.0;
        Complex a1 = new Complex(1.0, 0.0);
        phi = a1.getPhi();
        Assert.assertEquals((double)0.0, (double)phi, (double)0.0);
        Complex b1 = new Complex(1.0, 1.0);
        phi = b1.getPhi();
        Assert.assertEquals((double)45.0, (double)phi, (double)0.0);
        Complex c1 = new Complex(0.0, 1.0);
        phi = c1.getPhi();
        Assert.assertEquals((double)90.0, (double)phi, (double)0.0);
        Complex a2 = new Complex(-1.0, 1.0);
        phi = a2.getPhi();
        Assert.assertEquals((double)135.0, (double)phi, (double)0.0);
        Complex b2 = new Complex(-1.0, 0.0);
        phi = b2.getPhi();
        Assert.assertEquals((double)180.0, (double)phi, (double)0.0);
        Complex a3 = new Complex(-1.0, -1.0);
        phi = a3.getPhi();
        Assert.assertEquals((double)225.0, (double)phi, (double)0.0);
        Complex b3 = new Complex(0.0, -1.0);
        phi = b3.getPhi();
        Assert.assertEquals((double)270.0, (double)phi, (double)0.0);
        Complex a4 = new Complex(1.0, -1.0);
        phi = a4.getPhi();
        Assert.assertEquals((double)315.0, (double)phi, (double)0.0);
    }

    @Test
    public void testAdd() {
        Complex a = new Complex(1.0, 1.0);
        Complex b = new Complex(1.0, 1.0);
        Complex c = a.add(b);
        Assert.assertEquals((double)2.0, (double)c.getReal(), (double)0.0);
        Assert.assertEquals((double)2.0, (double)c.getImag(), (double)0.0);
    }

    @Test
    public void testSub() {
        Complex a = new Complex(2.0, 2.0);
        Complex b = new Complex(1.0, 1.0);
        Complex c = a.sub(b);
        Assert.assertEquals((double)1.0, (double)c.getReal(), (double)0.0);
        Assert.assertEquals((double)1.0, (double)c.getImag(), (double)0.0);
    }

    @Test
    public void testMulComplex() {
        Complex a = new Complex(1.0, 1.0);
        Complex b = new Complex(1.0, 1.0);
        Complex c = a.mul(b);
        Assert.assertEquals((double)0.0, (double)c.getReal(), (double)0.0);
        Assert.assertEquals((double)2.0, (double)c.getImag(), (double)0.0);
    }

    @Test
    public void testMulDouble() {
        Complex a = new Complex(1.0, 1.0);
        double s = 2.0;
        Complex c = a.mul(s);
        Assert.assertEquals((double)2.0, (double)c.getReal(), (double)0.0);
        Assert.assertEquals((double)2.0, (double)c.getImag(), (double)0.0);
    }

    @Test
    public void testDivComplex() {
        Complex a = new Complex(0.0, 2.0);
        Complex b = new Complex(1.0, 1.0);
        Complex c = a.div(b);
        Assert.assertEquals((double)1.0, (double)c.getReal(), (double)0.0);
        Assert.assertEquals((double)1.0, (double)c.getImag(), (double)0.0);
    }

    @Test
    public void testDivDouble() {
        Complex a = new Complex(1.0, 1.0);
        double s = 2.0;
        Complex c = a.div(s);
        Assert.assertEquals((double)0.5, (double)c.getReal(), (double)0.0);
        Assert.assertEquals((double)0.5, (double)c.getImag(), (double)0.0);
    }

    @Test
    public void testEquals() {
        boolean isEqual = false;
        Complex a = new Complex(1.0, 1.0);
        Complex b = new Complex(1.0, 1.0);
        isEqual = a.equals(b);
        Assert.assertTrue((boolean)isEqual);
        Complex c = new Complex(1.0, 1.0);
        Complex d = new Complex(1.0, 2.0);
        isEqual = c.equals(d);
        Assert.assertFalse((boolean)isEqual);
        Complex e = new Complex(1.0, 2.0);
        Complex f = new Complex(1.0, 1.0);
        isEqual = e.equals(f);
        Assert.assertFalse((boolean)isEqual);
        Complex g = new Complex(2.0, 1.0);
        Complex h = new Complex(1.0, 1.0);
        isEqual = g.equals(h);
        Assert.assertFalse((boolean)isEqual);
        Complex i = new Complex(1.0, 1.0);
        Complex j = new Complex(2.0, 1.0);
        isEqual = i.equals(j);
        Assert.assertFalse((boolean)isEqual);
    }
}

