/*
 * Decompiled with CFR 0.152.
 */
package math.jwave.transforms.wavelets;

import math.jwave.transforms.wavelets.Wavelet;

public class Haar02Orthogonal
extends Wavelet {
    public Haar02Orthogonal() {
        this._waveLength = 2;
        this._coeffs = new double[this._waveLength];
        this._coeffs[0] = 1.0;
        this._coeffs[1] = -1.0;
        this._scales = new double[this._waveLength];
        this._scales[0] = -this._coeffs[1];
        this._scales[1] = this._coeffs[0];
    }

    @Override
    public double[] forward(double[] arrTime) {
        double[] arrHilb = new double[arrTime.length];
        int k = 0;
        int h = arrTime.length >> 1;
        for (int i = 0; i < h; ++i) {
            for (int j = 0; j < this._waveLength; ++j) {
                k = (i << 1) + j;
                if (k >= arrTime.length) {
                    k -= arrTime.length;
                }
                int n = i;
                arrHilb[n] = arrHilb[n] + arrTime[k] * this._scales[j];
                int n2 = i + h;
                arrHilb[n2] = arrHilb[n2] + arrTime[k] * this._coeffs[j];
            }
        }
        return arrHilb;
    }

    @Override
    public double[] reverse(double[] arrHilb) {
        double[] arrTime = new double[arrHilb.length];
        int k = 0;
        int h = arrHilb.length >> 1;
        for (int i = 0; i < h; ++i) {
            for (int j = 0; j < this._waveLength; ++j) {
                k = (i << 1) + j;
                if (k >= arrHilb.length) {
                    k -= arrHilb.length;
                }
                int n = k;
                arrTime[n] = arrTime[n] + (arrHilb[i] * this._scales[j] + arrHilb[i + h] * this._coeffs[j]);
                int n2 = k;
                arrTime[n2] = arrTime[n2] * 0.5;
            }
        }
        return arrTime;
    }
}

