/*
 * Decompiled with CFR 0.152.
 */
package math.jwave.transforms;

import math.jwave.JUnitTests;
import math.jwave.Transform;
import math.jwave.exc.JWaveException;
import math.jwave.transforms.WaveletPacketTransform;
import math.jwave.transforms.wavelets.Daub02;
import math.jwave.transforms.wavelets.Haar02;
import org.junit.Test;

public class WaveletPacketTransformTest
extends JUnitTests {
    @Test
    public void testWaveletPacketTransformForwardHaar02Array() throws JWaveException {
        System.out.println("");
        System.out.println("testWaveletPacketTransformForwardHaar02Array");
        double delta = 1.0E-12;
        double[] arrTime = new double[]{2.0, 4.0, 7.0, 11.0};
        this.showTime(arrTime);
        Transform t = new Transform(new WaveletPacketTransform(new Haar02()));
        double[] arrHilb = t.forward(arrTime);
        this.showHilb(arrHilb);
        double[] expected = new double[]{12.0, -6.0, -3.0, 1.0};
        this.assertArray(expected, arrHilb, delta);
    }

    @Test
    public void testWaveletPacketTransformReverseHaar02Array() throws JWaveException {
        System.out.println("");
        System.out.println("testWaveletPacketTransformReverseHaar02Array");
        double delta = 1.0E-12;
        double[] arrHilb = new double[]{12.0, -6.0, -3.0, 1.0};
        this.showHilb(arrHilb);
        Transform t = new Transform(new WaveletPacketTransform(new Haar02()));
        double[] arrTime = t.reverse(arrHilb);
        this.showTime(arrTime);
        double[] expected = new double[]{2.0, 4.0, 7.0, 11.0};
        this.assertArray(expected, arrTime, delta);
    }

    @Test
    public void testWaveletPacketTransformForwardHaar02Matrix() throws JWaveException {
        System.out.println("");
        System.out.println("testWaveletPacketTransformForwardHaar02Matrix");
        double delta = 1.0E-12;
        double[][] matrixTime = new double[][]{{1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}};
        this.showTime(matrixTime);
        Transform t = new Transform(new WaveletPacketTransform(new Haar02()));
        double[][] matrixHilb = t.forward(matrixTime);
        this.showHilb(matrixHilb);
        double[][] expected = new double[][]{{4.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}};
        this.assertMatrix(expected, matrixHilb, delta);
    }

    @Test
    public void testWaveletPacketTransformReverseHaar02Matrix() throws JWaveException {
        System.out.println("");
        System.out.println("testWaveletPacketTransformReverseHaar02Matrix");
        double delta = 1.0E-12;
        double[][] matrixHilb = new double[][]{{4.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}};
        this.showHilb(matrixHilb);
        Transform t = new Transform(new WaveletPacketTransform(new Haar02()));
        double[][] matrixTime = t.reverse(matrixHilb);
        this.showTime(matrixTime);
        double[][] expected = new double[][]{{1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}};
        this.assertMatrix(expected, matrixTime, delta);
    }

    @Test
    public void testWaveletPacketTransformForwardHaar02Space() throws JWaveException {
        System.out.println("");
        System.out.println("testWaveletPacketTransformForwardHaar02Space");
        double delta = 1.0E-12;
        double[][][] spaceTime = new double[][][]{new double[][]{{1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}}, new double[][]{{1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}}, new double[][]{{1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}}, new double[][]{{1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}}};
        this.showTime(spaceTime);
        Transform t = new Transform(new WaveletPacketTransform(new Haar02()));
        double[][][] spaceHilb = t.forward(spaceTime);
        this.showHilb(spaceHilb);
        double[][][] expected = new double[][][]{new double[][]{{8.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}}, new double[][]{{0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}}, new double[][]{{0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}}, new double[][]{{0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}}};
        this.assertSpace(expected, spaceHilb, delta);
    }

    @Test
    public void testWaveletPacketTransformReverseHaar02Space() throws JWaveException {
        System.out.println("");
        System.out.println("testWaveletPacketTransformReverseHaar02Space");
        double delta = 1.0E-12;
        double[][][] spaceHilb = new double[][][]{new double[][]{{8.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}}, new double[][]{{0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}}, new double[][]{{0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}}, new double[][]{{0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}}};
        this.showHilb(spaceHilb);
        Transform t = new Transform(new WaveletPacketTransform(new Haar02()));
        double[][][] spaceTime = t.reverse(spaceHilb);
        this.showTime(spaceTime);
        double[][][] expected = new double[][][]{new double[][]{{1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}}, new double[][]{{1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}}, new double[][]{{1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}}, new double[][]{{1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}}};
        this.assertSpace(expected, spaceTime, delta);
    }

    @Test
    public void testWaveletPacketTransformForwardDaub04ArrayRandom() throws JWaveException {
        System.out.println("");
        System.out.println("testWaveletPacketTransformForwardDaub04ArrayRandom");
        double delta = 1.0E-12;
        double[] arrTime = new double[]{1.2, 2.3, 3.4, 4.5, 5.4, 4.3, 3.2, 2.1};
        this.showTime(arrTime);
        Transform t = new Transform(new WaveletPacketTransform(new Daub02()));
        double[] arrHilb = t.forward(arrTime);
        this.showHilb(arrHilb);
        double[] expected = new double[]{7.432531754730547, 5.76746824526945, 2.2766660498395392, -2.276666049839541, 0.9580127018922185, -0.9580127018922194, 0.2566987298107781, -0.25669872981077807};
        this.assertArray(expected, arrHilb, delta);
    }

    @Test
    public void testWaveletPacketTransformReverseDaub04ArrayRandom() throws JWaveException {
        System.out.println("");
        System.out.println("testWaveletPacketTransformReverseDaub04ArrayRandom");
        double delta = 1.0E-12;
        double[] arrHilb = new double[]{7.432531754730547, 5.76746824526945, 2.2766660498395392, -2.276666049839541, 0.9580127018922185, -0.9580127018922194, 0.2566987298107781, -0.25669872981077807};
        this.showHilb(arrHilb);
        Transform t = new Transform(new WaveletPacketTransform(new Daub02()));
        double[] arrTime = t.reverse(arrHilb);
        this.showTime(arrTime);
        double[] expected = new double[]{1.2, 2.3, 3.4, 4.5, 5.4, 4.3, 3.2, 2.1};
        this.assertArray(expected, arrTime, delta);
    }
}

