/*
 * Decompiled with CFR 0.152.
 */
package math.jwave.transforms;

import math.jwave.exc.JWaveException;
import math.jwave.transforms.WaveletTransform;
import math.jwave.transforms.wavelets.Wavelet;

public class WaveletPacketTransform
extends WaveletTransform {
    public WaveletPacketTransform(Wavelet wavelet) {
        super(wavelet);
        try {
            this.checkConfig();
        }
        catch (JWaveException e) {
            e.printStackTrace();
        }
    }

    public WaveletPacketTransform(Wavelet wavelet, int steps) {
        super(wavelet, steps);
        try {
            this.checkConfig();
        }
        catch (JWaveException e) {
            e.printStackTrace();
        }
    }

    @Override
    public double[] forward(double[] arrTime) {
        double[] arrHilb = new double[arrTime.length];
        for (int i = 0; i < arrTime.length; ++i) {
            arrHilb[i] = arrTime[i];
        }
        int k = arrTime.length;
        int h = arrTime.length;
        int minWaveLength = this._wavelet.getWaveLength();
        if (h >= minWaveLength) {
            for (int level = 0; h >= minWaveLength && (level < this._steps || this._steps == -1); h >>= 1, ++level) {
                int g = k / h;
                for (int p = 0; p < g; ++p) {
                    double[] iBuf = new double[h];
                    for (int i = 0; i < h; ++i) {
                        iBuf[i] = arrHilb[i + p * h];
                    }
                    double[] oBuf = this._wavelet.forward(iBuf);
                    for (int i = 0; i < h; ++i) {
                        arrHilb[i + p * h] = oBuf[i];
                    }
                }
            }
        }
        return arrHilb;
    }

    @Override
    public double[] reverse(double[] arrHilb) {
        double[] arrTime = new double[arrHilb.length];
        for (int i = 0; i < arrHilb.length; ++i) {
            arrTime[i] = arrHilb[i];
        }
        int level = 0;
        int minWaveLength = this._wavelet.getWaveLength();
        int k = arrTime.length;
        if (arrHilb.length >= minWaveLength) {
            for (int h = minWaveLength; h <= arrTime.length && h >= minWaveLength && (level < this._steps || this._steps == -1); h <<= 1, ++level) {
                int g = k / h;
                for (int p = 0; p < g; ++p) {
                    double[] iBuf = new double[h];
                    for (int i = 0; i < h; ++i) {
                        iBuf[i] = arrTime[i + p * h];
                    }
                    double[] oBuf = this._wavelet.reverse(iBuf);
                    for (int i = 0; i < h; ++i) {
                        arrTime[i + p * h] = oBuf[i];
                    }
                }
            }
        }
        return arrTime;
    }
}

