/*
 * Decompiled with CFR 0.152.
 */
package math.jwave.transforms;

import math.jwave.JUnitTests;
import math.jwave.Transform;
import math.jwave.datatypes.Complex;
import math.jwave.transforms.DiscreteFourierTransform;
import org.junit.Test;

public class DiscreteFourierTransformTest
extends JUnitTests {
    @Test
    public void testForwardDoubleArray() {
        System.out.println("");
        System.out.println("testDiscreteFourierTransformForwardDoubleArray");
        double delta = 1.0E-12;
        double[] arrTime = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
        this.showTime(arrTime);
        Transform t = new Transform(new DiscreteFourierTransform());
        double[] arrFreq = t.forward(arrTime);
        this.showFreq(arrFreq);
        double[] expected = new double[]{1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        this.assertArray(expected, arrFreq, delta);
    }

    @Test
    public void testReverseDoubleArray() {
        System.out.println("");
        System.out.println("testDiscreteFourierTransformReverseDoubleArray");
        double delta = 1.0E-12;
        double[] arrFreq = new double[]{1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        this.showHilb(arrFreq);
        Transform t = new Transform(new DiscreteFourierTransform());
        double[] arrTime = t.reverse(arrFreq);
        this.showTime(arrTime);
        double[] expected = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
        this.assertArray(expected, arrTime, delta);
    }

    @Test
    public void testForwardComplexArray() {
        System.out.println("");
        System.out.println("testDiscreteFourierTransformForwardComplexArray");
        double delta = 1.0E-12;
        Complex[] arrTime = new Complex[]{new Complex(1.0, 1.0), new Complex(1.0, 1.0), new Complex(1.0, 1.0), new Complex(1.0, 1.0)};
        this.showTime(arrTime);
        Transform t = new Transform(new DiscreteFourierTransform());
        Complex[] arrFreq = t.forward(arrTime);
        this.showFreq(arrFreq);
        Complex[] expected = new Complex[]{new Complex(1.0, 1.0), new Complex(0.0, 0.0), new Complex(0.0, 0.0), new Complex(0.0, 0.0)};
        this.assertArray(expected, arrFreq, delta);
    }

    @Test
    public void testReverseComplexArray() {
        System.out.println("");
        System.out.println("testDiscreteFourierTransformReverseDoubleArray");
        double delta = 1.0E-12;
        Complex[] arrFreq = new Complex[]{new Complex(1.0, 1.0), new Complex(0.0, 0.0), new Complex(0.0, 0.0), new Complex(0.0, 0.0)};
        this.showFreq(arrFreq);
        Transform t = new Transform(new DiscreteFourierTransform());
        Complex[] arrTime = t.reverse(arrFreq);
        this.showTime(arrTime);
        Complex[] expected = new Complex[]{new Complex(1.0, 1.0), new Complex(1.0, 1.0), new Complex(1.0, 1.0), new Complex(1.0, 1.0)};
        this.assertArray(expected, arrTime, delta);
    }
}

