/*
 * Decompiled with CFR 0.152.
 */
package math.jwave.transforms;

import math.jwave.JUnitTests;
import math.jwave.Transform;
import math.jwave.exc.JWaveException;
import math.jwave.transforms.AncientEgyptianDecomposition;
import math.jwave.transforms.FastWaveletTransform;
import math.jwave.transforms.WaveletPacketTransform;
import math.jwave.transforms.wavelets.Haar02;
import org.junit.Test;

public class AncientEgyptianDecompositionTest
extends JUnitTests {
    @Test
    public void testAncientEgyptianDecompositionFwtForwardHaar02Array() throws JWaveException {
        System.out.println("");
        System.out.println("testAncientEgyptianDecompositionFwtForwardHaar02Array");
        double delta = 1.0E-12;
        double[] arrTime = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
        this.showTime(arrTime);
        Transform t = new Transform(new AncientEgyptianDecomposition(new FastWaveletTransform(new Haar02())));
        double[] arrHilb = t.forward(arrTime);
        this.showHilb(arrHilb);
        double[] expected = new double[]{2.0, 0.0, 0.0, 0.0, Math.sqrt(2.0), 0.0, 1.0};
        this.assertArray(expected, arrHilb, delta);
    }

    @Test
    public void testAncientEgyptianDecompositionFwtReverseHaar02Array() throws JWaveException {
        System.out.println("");
        System.out.println("testAncientEgyptianDecompositionFwtReverseHaar02Array");
        double delta = 1.0E-12;
        double[] arrHilb = new double[]{2.0, 0.0, 0.0, 0.0, Math.sqrt(2.0), 0.0, 1.0};
        this.showHilb(arrHilb);
        Transform t = new Transform(new AncientEgyptianDecomposition(new FastWaveletTransform(new Haar02())));
        double[] arrTime = t.reverse(arrHilb);
        this.showTime(arrTime);
        double[] expected = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
        this.assertArray(expected, arrTime, delta);
    }

    @Test
    public void testAncientEgyptianDecompositionWptForwardHaar02Array() throws JWaveException {
        System.out.println("");
        System.out.println("testAncientEgyptianDecompositionWptForwardHaar02Array");
        double delta = 1.0E-12;
        double[] arrTime = new double[]{1.0, 2.0, 3.0, 4.0, 2.0, 0.0, 1.0};
        this.showTime(arrTime);
        Transform t = new Transform(new AncientEgyptianDecomposition(new WaveletPacketTransform(new Haar02())));
        double[] arrHilb = t.forward(arrTime);
        this.showHilb(arrHilb);
        double sqrt2 = Math.sqrt(2.0);
        double[] expected = new double[]{5.0, -2.0, -1.0, 0.0, sqrt2, sqrt2, 1.0};
        this.assertArray(expected, arrHilb, delta);
    }

    @Test
    public void testAncientEgyptianDecompositionWptReverseHaar02Array() throws JWaveException {
        System.out.println("");
        System.out.println("testAncientEgyptianDecompositionWptReverseHaar02Array");
        double delta = 1.0E-12;
        double sqrt2 = Math.sqrt(2.0);
        double[] arrHilb = new double[]{5.0, -2.0, -1.0, 0.0, sqrt2, sqrt2, 1.0};
        this.showHilb(arrHilb);
        Transform t = new Transform(new AncientEgyptianDecomposition(new WaveletPacketTransform(new Haar02())));
        double[] arrTime = t.reverse(arrHilb);
        this.showTime(arrTime);
        double[] expected = new double[]{1.0, 2.0, 3.0, 4.0, 2.0, 0.0, 1.0};
        this.assertArray(expected, arrTime, delta);
    }
}

