/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.timeseries;

import java.util.Iterator;
import net.finmath.timeseries.TimeSeriesInterface;

public class TimeSeriesView
implements TimeSeriesInterface {
    private final TimeSeriesInterface timeSeries;
    private final int indexStart;
    private final int indexEnd;

    public TimeSeriesView(TimeSeriesInterface timeSeriesInterface, int n, int n2) {
        this.timeSeries = timeSeriesInterface;
        this.indexStart = n;
        this.indexEnd = n2;
    }

    @Override
    public double getTime(int n) {
        return this.timeSeries.getTime(this.indexStart + n);
    }

    @Override
    public double getValue(int n) {
        return this.timeSeries.getValue(this.indexStart + n);
    }

    @Override
    public int getNumberOfTimePoints() {
        return this.indexEnd - this.indexStart + 1;
    }

    @Override
    public Iterable<Double> getValues() {
        return new Iterable<Double>(){
            private int index = 0;

            @Override
            public Iterator<Double> iterator() {
                return new Iterator<Double>(){

                    @Override
                    public boolean hasNext() {
                        return index < TimeSeriesView.this.getNumberOfTimePoints();
                    }

                    @Override
                    public Double next() {
                        return TimeSeriesView.this.getValue(index++);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }
}

