/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.time;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import net.finmath.time.TimeDiscretizationInterface;

public class TimeDiscretization
implements Serializable,
TimeDiscretizationInterface {
    private static final long serialVersionUID = 6880668325019167781L;
    private final double[] timeDiscretization;
    private final double timeTickSize = 1.1415525114155251E-4;

    public TimeDiscretization(double ... dArray) {
        this.timeDiscretization = (double[])dArray.clone();
        Arrays.sort(this.timeDiscretization);
    }

    public TimeDiscretization(Double[] doubleArray) {
        this.timeDiscretization = new double[doubleArray.length];
        for (int i = 0; i < this.timeDiscretization.length; ++i) {
            this.timeDiscretization[i] = this.roundToTimeTickSize(doubleArray[i]);
        }
        Arrays.sort(this.timeDiscretization);
    }

    public TimeDiscretization(ArrayList<Double> arrayList) {
        this.timeDiscretization = new double[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            this.timeDiscretization[i] = this.roundToTimeTickSize(arrayList.get(i));
        }
        Arrays.sort(this.timeDiscretization);
    }

    public TimeDiscretization(Set<Double> set) {
        this.timeDiscretization = new double[set.size()];
        Iterator<Double> iterator = set.iterator();
        for (int i = 0; i < this.timeDiscretization.length; ++i) {
            this.timeDiscretization[i] = this.roundToTimeTickSize(iterator.next());
        }
        Arrays.sort(this.timeDiscretization);
    }

    public TimeDiscretization(double d, int n, double d2) {
        this.timeDiscretization = new double[n + 1];
        for (int i = 0; i < this.timeDiscretization.length; ++i) {
            this.timeDiscretization[i] = this.roundToTimeTickSize(d + (double)i * d2);
        }
    }

    public TimeDiscretization(double d, double d2, double d3, ShortPeriodLocation shortPeriodLocation) {
        int n = (int)((d2 - d) / d3 + 0.5);
        if (this.roundToTimeTickSize(d + (double)n * d3) < this.roundToTimeTickSize(d2)) {
            ++n;
        }
        this.timeDiscretization = new double[n + 1];
        if (shortPeriodLocation == ShortPeriodLocation.SHORT_PERIOD_AT_END) {
            for (int i = 0; i < this.timeDiscretization.length; ++i) {
                this.timeDiscretization[i] = this.roundToTimeTickSize(d + (double)i * d3);
            }
            this.timeDiscretization[this.timeDiscretization.length - 1] = d2;
        } else {
            for (int i = 0; i < this.timeDiscretization.length; ++i) {
                this.timeDiscretization[i] = this.roundToTimeTickSize(d2 - (double)(n - i) * d3);
            }
            this.timeDiscretization[0] = d;
        }
    }

    @Override
    public int getNumberOfTimes() {
        return this.timeDiscretization.length;
    }

    @Override
    public int getNumberOfTimeSteps() {
        return this.timeDiscretization.length - 1;
    }

    @Override
    public double getTime(int n) {
        return this.timeDiscretization[n];
    }

    @Override
    public double getTimeStep(int n) {
        return this.timeDiscretization[n + 1] - this.timeDiscretization[n];
    }

    @Override
    public int getTimeIndex(double d) {
        int n = Arrays.binarySearch(this.timeDiscretization, this.roundToTimeTickSize(d));
        return n;
    }

    @Override
    public int getTimeIndexNearestLessOrEqual(double d) {
        int n = Arrays.binarySearch(this.timeDiscretization, this.roundToTimeTickSize(d));
        if (n < 0) {
            n = -n - 2;
        }
        return n;
    }

    @Override
    public int getTimeIndexNearestGreaterOrEqual(double d) {
        int n = Arrays.binarySearch(this.timeDiscretization, d);
        if (n < 0) {
            n = -n - 1;
        }
        return n;
    }

    @Override
    public double[] getAsDoubleArray() {
        return (double[])this.timeDiscretization.clone();
    }

    @Override
    public ArrayList<Double> getAsArrayList() {
        ArrayList<Double> arrayList = new ArrayList<Double>(this.timeDiscretization.length);
        for (double d : this.timeDiscretization) {
            arrayList.add(d);
        }
        return arrayList;
    }

    @Override
    public TimeDiscretizationInterface getTimeShiftedTimeDiscretization(double d) {
        double[] dArray = new double[this.timeDiscretization.length];
        for (int i = 0; i < this.timeDiscretization.length; ++i) {
            dArray[i] = this.roundToTimeTickSize(this.timeDiscretization[i] + d);
        }
        Arrays.sort(this.timeDiscretization);
        return new TimeDiscretization(dArray);
    }

    @Override
    public Iterator<Double> iterator() {
        return this.getAsArrayList().iterator();
    }

    public String toString() {
        return "TimeDiscretization [timeDiscretization=" + Arrays.toString(this.timeDiscretization) + ", timeTickSize=" + 1.1415525114155251E-4 + "]";
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + Arrays.hashCode(this.timeDiscretization);
        long l = Double.doubleToLongBits(1.1415525114155251E-4);
        n = 31 * n + (int)(l ^ l >>> 32);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        TimeDiscretization timeDiscretization = (TimeDiscretization)object;
        if (!Arrays.equals(this.timeDiscretization, timeDiscretization.timeDiscretization)) {
            return false;
        }
        return Double.doubleToLongBits(1.1415525114155251E-4) == Double.doubleToLongBits(timeDiscretization.timeTickSize);
    }

    private double roundToTimeTickSize(double d) {
        return Math.rint(d / 1.1415525114155251E-4) * 1.1415525114155251E-4;
    }

    public static enum ShortPeriodLocation {
        SHORT_PERIOD_AT_START,
        SHORT_PERIOD_AT_END;

    }
}

