/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.tests.time.daycount;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import net.finmath.time.Period;
import net.finmath.time.daycount.DayCountConvention_30E_360;
import net.finmath.time.daycount.DayCountConvention_ACT_ACT_ICMA;
import net.finmath.time.daycount.DayCountConvention_ACT_ACT_ISDA;
import org.junit.Assert;
import org.junit.Test;

public class DayCountConventionTest {
    @Test
    public void testDayCountConvention_ACT_ACT_ISDA() {
        DayCountConvention_ACT_ACT_ISDA dayCountConvention_ACT_ACT_ISDA = new DayCountConvention_ACT_ACT_ISDA();
        double d = dayCountConvention_ACT_ACT_ISDA.getDaycountFraction(new GregorianCalendar(2003, 10, 1), new GregorianCalendar(2004, 4, 1));
        Assert.assertTrue((Math.abs(d - 0.49772438056740775) < 1.0E-8 ? 1 : 0) != 0);
        d = dayCountConvention_ACT_ACT_ISDA.getDaycountFraction(new GregorianCalendar(1999, 1, 1), new GregorianCalendar(1999, 6, 1));
        Assert.assertTrue((Math.abs(d - 0.410958904109589) < 1.0E-8 ? 1 : 0) != 0);
        d = dayCountConvention_ACT_ACT_ISDA.getDaycountFraction(new GregorianCalendar(1999, 6, 1), new GregorianCalendar(2000, 6, 1));
        Assert.assertTrue((Math.abs(d - 1.0013773486039375) < 1.0E-8 ? 1 : 0) != 0);
        d = dayCountConvention_ACT_ACT_ISDA.getDaycountFraction(new GregorianCalendar(2002, 7, 15), new GregorianCalendar(2003, 6, 15));
        Assert.assertTrue((Math.abs(d - 0.915068493150685) < 1.0E-8 ? 1 : 0) != 0);
        d = dayCountConvention_ACT_ACT_ISDA.getDaycountFraction(new GregorianCalendar(2003, 6, 15), new GregorianCalendar(2004, 0, 15));
        Assert.assertTrue((Math.abs(d - 0.5040047907777528) < 1.0E-8 ? 1 : 0) != 0);
        d = dayCountConvention_ACT_ACT_ISDA.getDaycountFraction(new GregorianCalendar(2000, 0, 30), new GregorianCalendar(2000, 5, 30));
        Assert.assertTrue((Math.abs(d - 0.41530054644808745) < 1.0E-8 ? 1 : 0) != 0);
        d = dayCountConvention_ACT_ACT_ISDA.getDaycountFraction(new GregorianCalendar(1999, 10, 30), new GregorianCalendar(2000, 3, 30));
        Assert.assertTrue((Math.abs(d - 0.4155400853357287) < 1.0E-8 ? 1 : 0) != 0);
    }

    @Test
    public void testDayCountConventionAdditivity_ACT_ACT_ISDA() {
        double d;
        double d2;
        DayCountConvention_ACT_ACT_ISDA dayCountConvention_ACT_ACT_ISDA = new DayCountConvention_ACT_ACT_ISDA();
        double d3 = dayCountConvention_ACT_ACT_ISDA.getDaycountFraction(new GregorianCalendar(2012, 2, 19), new GregorianCalendar(2013, 7, 4));
        Assert.assertTrue((Math.abs(d3 - ((d2 = dayCountConvention_ACT_ACT_ISDA.getDaycountFraction(new GregorianCalendar(2012, 2, 19), new GregorianCalendar(2013, 0, 1))) + (d = dayCountConvention_ACT_ACT_ISDA.getDaycountFraction(new GregorianCalendar(2013, 0, 1), new GregorianCalendar(2013, 7, 4))))) < 1.0E-8 ? 1 : 0) != 0);
    }

    @Test
    public void testDayCountConvention_30E_360() {
        DayCountConvention_30E_360 dayCountConvention_30E_360 = new DayCountConvention_30E_360();
        double d = dayCountConvention_30E_360.getDaycountFraction(new GregorianCalendar(2003, 10, 1), new GregorianCalendar(2004, 4, 1));
        Assert.assertTrue((Math.abs(d - 0.5) < 1.0E-8 ? 1 : 0) != 0);
        d = dayCountConvention_30E_360.getDaycountFraction(new GregorianCalendar(1999, 1, 1), new GregorianCalendar(1999, 6, 1));
        Assert.assertTrue((Math.abs(d - 0.4166666666666667) < 1.0E-8 ? 1 : 0) != 0);
    }

    @Test
    public void testDayCountConventionAdditivity_ACT_ACT_ICMA() {
        double d;
        double d2;
        ArrayList<Period> arrayList = new ArrayList<Period>();
        for (int i = 1980; i < 2100; ++i) {
            GregorianCalendar gregorianCalendar = new GregorianCalendar(i, 1, 15);
            GregorianCalendar gregorianCalendar2 = new GregorianCalendar(i, 4, 31);
            arrayList.add(new Period(gregorianCalendar, gregorianCalendar2, gregorianCalendar, gregorianCalendar2));
            gregorianCalendar = new GregorianCalendar(i, 4, 15);
            gregorianCalendar2 = new GregorianCalendar(i, 7, 31);
            arrayList.add(new Period(gregorianCalendar, gregorianCalendar2, gregorianCalendar, gregorianCalendar2));
            gregorianCalendar = new GregorianCalendar(i, 7, 15);
            gregorianCalendar2 = new GregorianCalendar(i, 10, 31);
            arrayList.add(new Period(gregorianCalendar, gregorianCalendar2, gregorianCalendar, gregorianCalendar2));
            gregorianCalendar = new GregorianCalendar(i, 10, 15);
            gregorianCalendar2 = new GregorianCalendar(i + 1, 1, 31);
            arrayList.add(new Period(gregorianCalendar, gregorianCalendar2, gregorianCalendar, gregorianCalendar2));
        }
        DayCountConvention_ACT_ACT_ICMA dayCountConvention_ACT_ACT_ICMA = new DayCountConvention_ACT_ACT_ICMA(arrayList, 4);
        double d3 = dayCountConvention_ACT_ACT_ICMA.getDaycountFraction(new GregorianCalendar(2012, 2, 19), new GregorianCalendar(2013, 7, 4));
        Assert.assertTrue((Math.abs(d3 - ((d2 = dayCountConvention_ACT_ACT_ICMA.getDaycountFraction(new GregorianCalendar(2012, 2, 19), new GregorianCalendar(2013, 0, 1))) + (d = dayCountConvention_ACT_ACT_ICMA.getDaycountFraction(new GregorianCalendar(2013, 0, 1), new GregorianCalendar(2013, 7, 4))))) < 1.0E-8 ? 1 : 0) != 0);
    }

    @Test
    public void testDayCountConventionConsistency_ACT_ACT_ICMA_versus_ACT_ACT_ISDA() {
        GregorianCalendar[] gregorianCalendarArray;
        Object object;
        ArrayList<Period> arrayList = new ArrayList<Period>();
        for (int i = 1980; i < 2100; ++i) {
            object = new GregorianCalendar(i, 0, 1);
            gregorianCalendarArray = new GregorianCalendar(i, 11, 31);
            arrayList.add(new Period((Calendar)object, (Calendar)gregorianCalendarArray, (Calendar)object, (Calendar)gregorianCalendarArray));
        }
        DayCountConvention_ACT_ACT_ICMA dayCountConvention_ACT_ACT_ICMA = new DayCountConvention_ACT_ACT_ICMA(arrayList, 1);
        object = new DayCountConvention_ACT_ACT_ISDA();
        gregorianCalendarArray = new GregorianCalendar[]{new GregorianCalendar(2003, 10, 1), new GregorianCalendar(1999, 1, 1), new GregorianCalendar(1999, 6, 1), new GregorianCalendar(2002, 7, 15), new GregorianCalendar(2003, 6, 15), new GregorianCalendar(2000, 0, 30), new GregorianCalendar(1999, 10, 30), new GregorianCalendar(1999, 0, 1), new GregorianCalendar(2014, 1, 1)};
        GregorianCalendar[] gregorianCalendarArray2 = new GregorianCalendar[]{new GregorianCalendar(2004, 4, 1), new GregorianCalendar(1999, 6, 1), new GregorianCalendar(2000, 6, 1), new GregorianCalendar(2003, 6, 15), new GregorianCalendar(2004, 0, 15), new GregorianCalendar(2000, 5, 30), new GregorianCalendar(2000, 3, 30), new GregorianCalendar(2014, 2, 1), new GregorianCalendar(2014, 2, 1)};
        for (int i = 0; i < gregorianCalendarArray.length; ++i) {
            double d;
            double d2 = dayCountConvention_ACT_ACT_ICMA.getDaycount(gregorianCalendarArray[i], gregorianCalendarArray2[i]);
            Assert.assertTrue((Math.abs(d2 - (d = object.getDaycount(gregorianCalendarArray[i], gregorianCalendarArray2[i]))) < 1.0E-8 ? 1 : 0) != 0);
        }
    }
}

