/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.tests.optimizer;

import java.util.ArrayList;
import net.finmath.optimizer.LevenbergMarquardt;
import net.finmath.optimizer.SolverException;
import org.junit.Assert;
import org.junit.Test;

public class LevenbergMarquardtTest {
    @Test
    public void testSmallLinearSystem() throws CloneNotSupportedException, SolverException {
        LevenbergMarquardt levenbergMarquardt = new LevenbergMarquardt(){

            @Override
            public void setValues(double[] dArray, double[] dArray2) {
                dArray2[0] = dArray[0] * 0.0 + dArray[1];
                dArray2[1] = dArray[0] * 2.0 + dArray[1];
            }
        };
        levenbergMarquardt.setInitialParameters(new double[]{0.0, 0.0});
        levenbergMarquardt.setWeights(new double[]{1.0, 1.0});
        levenbergMarquardt.setMaxIteration(100);
        levenbergMarquardt.setTargetValues(new double[]{5.0, 10.0});
        levenbergMarquardt.run();
        double[] dArray = levenbergMarquardt.getBestFitParameters();
        System.out.println("The solver for problem 1 required " + levenbergMarquardt.getIterations() + " iterations. Accuracy is " + levenbergMarquardt.getRootMeanSquaredError() + ". The best fit parameters are:");
        for (int i = 0; i < dArray.length; ++i) {
            System.out.println("\tparameter[" + i + "]: " + dArray[i]);
        }
        System.out.println();
        Assert.assertTrue((Math.abs(dArray[0] - 2.5) < 1.0E-12 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(dArray[1] - 5.0) < 1.0E-12 ? 1 : 0) != 0);
        LevenbergMarquardt levenbergMarquardt2 = levenbergMarquardt.getCloneWithModifiedTargetValues(new double[]{5.1, 10.2}, new double[]{1.0, 1.0}, true);
        levenbergMarquardt2.run();
        double[] dArray2 = levenbergMarquardt2.getBestFitParameters();
        System.out.println("The solver for problem 2 required " + levenbergMarquardt2.getIterations() + " iterations. Accuracy is " + levenbergMarquardt2.getRootMeanSquaredError() + ". The best fit parameters are:");
        for (int i = 0; i < dArray2.length; ++i) {
            System.out.println("\tparameter[" + i + "]: " + dArray2[i]);
        }
        System.out.println();
        Assert.assertTrue((Math.abs(dArray2[0] - 2.55) < 1.0E-12 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(dArray2[1] - 5.1) < 1.0E-12 ? 1 : 0) != 0);
    }

    @Test
    public void testMultiThreaddedOptimizer() throws SolverException {
        LevenbergMarquardt levenbergMarquardt = new LevenbergMarquardt(new double[]{0.0, 0.0, 0.0}, new double[]{5.0, 10.0, 2.0}, 100, 10){

            @Override
            public void setValues(double[] dArray, double[] dArray2) {
                dArray2[0] = 1.0 * dArray[0] + 2.0 * dArray[1] + dArray[2] + dArray[0] * dArray[1];
                dArray2[1] = 2.0 * dArray[0] + 1.0 * dArray[1] + dArray[2] + dArray[1] * dArray[2];
                dArray2[2] = 3.0 * dArray[0] + 0.0 * dArray[1] + dArray[2];
            }
        };
        levenbergMarquardt.run();
        double[] dArray = levenbergMarquardt.getBestFitParameters();
        System.out.println("The solver for problem 3 required " + levenbergMarquardt.getIterations() + " iterations. Accuracy is " + levenbergMarquardt.getRootMeanSquaredError() + ". The best fit parameters are:");
        for (int i = 0; i < dArray.length; ++i) {
            System.out.println("\tparameter[" + i + "]: " + dArray[i]);
        }
        double[] dArray2 = new double[3];
        levenbergMarquardt.setValues(dArray, dArray2);
        for (int i = 0; i < dArray.length; ++i) {
            System.out.println("\tvalue[" + i + "]: " + dArray2[i]);
        }
        System.out.println();
        Assert.assertTrue((levenbergMarquardt.getRootMeanSquaredError() < 0.1 ? 1 : 0) != 0);
    }

    @Test
    public void testRosenbrockFunction() throws SolverException {
        LevenbergMarquardt levenbergMarquardt = new LevenbergMarquardt(new double[]{0.5, 0.5}, new double[]{0.0, 0.0}, 100, 10){

            @Override
            public void setValues(double[] dArray, double[] dArray2) {
                dArray2[0] = 10.0 * (dArray[1] - dArray[0] * dArray[0]);
                dArray2[1] = 1.0 - dArray[0];
            }
        };
        levenbergMarquardt.run();
        double[] dArray = levenbergMarquardt.getBestFitParameters();
        System.out.println("The solver for problem 'Rosebrock' required " + levenbergMarquardt.getIterations() + " iterations. Accuracy is " + levenbergMarquardt.getRootMeanSquaredError() + ". The best fit parameters are:");
        for (int i = 0; i < dArray.length; ++i) {
            System.out.println("\tparameter[" + i + "]: " + dArray[i]);
        }
        double[] dArray2 = new double[2];
        levenbergMarquardt.setValues(dArray, dArray2);
        for (int i = 0; i < dArray2.length; ++i) {
            System.out.println("\tvalue[" + i + "]: " + dArray2[i]);
        }
        System.out.println();
        Assert.assertTrue((Math.abs(dArray[0] - 1.0) < 1.0E-10 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(dArray[1] - 1.0) < 1.0E-10 ? 1 : 0) != 0);
    }

    @Test
    public void testRosenbrockFunctionWithList() throws SolverException {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        arrayList.add(0.5);
        arrayList.add(0.5);
        ArrayList<Double> arrayList2 = new ArrayList<Double>();
        arrayList2.add(0.0);
        arrayList2.add(0.0);
        LevenbergMarquardt levenbergMarquardt = new LevenbergMarquardt(arrayList, arrayList2, 100, 10){

            @Override
            public void setValues(double[] dArray, double[] dArray2) {
                dArray2[0] = 10.0 * (dArray[1] - dArray[0] * dArray[0]);
                dArray2[1] = 1.0 - dArray[0];
            }
        };
        levenbergMarquardt.run();
        double[] dArray = levenbergMarquardt.getBestFitParameters();
        System.out.println("The solver for problem 'Rosebrock' required " + levenbergMarquardt.getIterations() + " iterations. Accuracy is " + levenbergMarquardt.getRootMeanSquaredError() + ". The best fit parameters are:");
        for (int i = 0; i < dArray.length; ++i) {
            System.out.println("\tparameter[" + i + "]: " + dArray[i]);
        }
        double[] dArray2 = new double[2];
        levenbergMarquardt.setValues(dArray, dArray2);
        for (int i = 0; i < dArray2.length; ++i) {
            System.out.println("\tvalue[" + i + "]: " + dArray2[i]);
        }
        System.out.println();
        Assert.assertTrue((Math.abs(dArray[0] - 1.0) < 1.0E-10 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(dArray[1] - 1.0) < 1.0E-10 ? 1 : 0) != 0);
    }
}

