/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.tests.montecarlo.interestrate;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import net.finmath.exception.CalculationException;
import net.finmath.marketdata.model.AnalyticModel;
import net.finmath.marketdata.model.AnalyticModelInterface;
import net.finmath.marketdata.model.curves.DiscountCurve;
import net.finmath.marketdata.model.curves.DiscountCurveInterface;
import net.finmath.marketdata.model.curves.ForwardCurve;
import net.finmath.marketdata.model.curves.ForwardCurveInterface;
import net.finmath.marketdata.model.volatilities.AbstractVolatilitySurface;
import net.finmath.marketdata.model.volatilities.CapletVolatilitiesParametric;
import net.finmath.marketdata.products.Cap;
import net.finmath.montecarlo.BrownianMotion;
import net.finmath.montecarlo.interestrate.LIBORMarketModel;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulation;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.interestrate.modelplugins.AbstractLIBORCovarianceModel;
import net.finmath.montecarlo.interestrate.modelplugins.LIBORCorrelationModelExponentialDecay;
import net.finmath.montecarlo.interestrate.modelplugins.LIBORCovarianceModelFromVolatilityAndCorrelation;
import net.finmath.montecarlo.interestrate.modelplugins.LIBORVolatilityModelFourParameterExponentialFormIntegrated;
import net.finmath.montecarlo.interestrate.products.FlexiCap;
import net.finmath.montecarlo.process.ProcessEulerScheme;
import net.finmath.time.RegularSchedule;
import net.finmath.time.TimeDiscretization;
import net.finmath.time.TimeDiscretizationInterface;
import org.junit.Assert;
import org.junit.Test;

public class CapValuationTest {
    Calendar referenceDate = new GregorianCalendar(2014, 5, 15);
    private ForwardCurveInterface forwardCurve;
    private DiscountCurveInterface discountCurve;
    private LIBORModelMonteCarloSimulationInterface liborMarketModel;
    private AbstractVolatilitySurface capletVol;
    private static DecimalFormat formatterMaturity = new DecimalFormat("00.00", new DecimalFormatSymbols(Locale.ENGLISH));
    private static DecimalFormat formatterValue = new DecimalFormat(" ##0.000%;-##0.000%", new DecimalFormatSymbols(Locale.ENGLISH));
    private static DecimalFormat formatterDeviation = new DecimalFormat(" 0.00000E00;-0.00000E00", new DecimalFormatSymbols(Locale.ENGLISH));

    public CapValuationTest() throws CalculationException {
        this.init(10000);
    }

    private void init(int n) throws CalculationException {
        double d = 0.25;
        double d2 = 20.0;
        TimeDiscretization timeDiscretization = new TimeDiscretization(0.0, (int)(d2 / d), d);
        this.forwardCurve = ForwardCurve.createForwardCurveFromForwards("forwardCurve", new double[]{0.5, 1.0, 2.0, 5.0, 40.0}, new double[]{0.05, 0.05, 0.05, 0.05, 0.05}, d);
        this.discountCurve = DiscountCurve.createDiscountCurveFromZeroRates("discountCurve", new double[]{0.5, 1.0, 2.0, 5.0, 40.0}, new double[]{0.04, 0.04, 0.04, 0.04, 0.05});
        double d3 = 0.25;
        double d4 = 3.0;
        double d5 = 1.5;
        double d6 = 0.1;
        this.capletVol = new CapletVolatilitiesParametric("EUR", this.referenceDate, d3, d4, d5, d6);
        double d7 = 20.0;
        double d8 = 0.25;
        TimeDiscretization timeDiscretization2 = new TimeDiscretization(0.0, (int)(d7 / d8), d8);
        LIBORVolatilityModelFourParameterExponentialFormIntegrated lIBORVolatilityModelFourParameterExponentialFormIntegrated = new LIBORVolatilityModelFourParameterExponentialFormIntegrated(timeDiscretization2, timeDiscretization, d3, d4, d5, d6, false);
        int n2 = 1;
        double d9 = 0.0;
        LIBORCorrelationModelExponentialDecay lIBORCorrelationModelExponentialDecay = new LIBORCorrelationModelExponentialDecay(timeDiscretization2, timeDiscretization, n2, d9);
        LIBORCovarianceModelFromVolatilityAndCorrelation lIBORCovarianceModelFromVolatilityAndCorrelation = new LIBORCovarianceModelFromVolatilityAndCorrelation(timeDiscretization2, timeDiscretization, lIBORVolatilityModelFourParameterExponentialFormIntegrated, lIBORCorrelationModelExponentialDecay);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("measure", LIBORMarketModel.Measure.SPOT.name());
        hashMap.put("stateSpace", LIBORMarketModel.StateSpace.LOGNORMAL.name());
        LIBORMarketModel.CalibrationItem[] calibrationItemArray = new LIBORMarketModel.CalibrationItem[]{};
        LIBORMarketModel lIBORMarketModel = new LIBORMarketModel((TimeDiscretizationInterface)timeDiscretization, this.forwardCurve, this.discountCurve, (AbstractLIBORCovarianceModel)lIBORCovarianceModelFromVolatilityAndCorrelation, calibrationItemArray, hashMap);
        ProcessEulerScheme processEulerScheme = new ProcessEulerScheme(new BrownianMotion(timeDiscretization2, n2, n, 3141));
        this.liborMarketModel = new LIBORModelMonteCarloSimulation(lIBORMarketModel, processEulerScheme);
    }

    @Test
    public void testCap() throws CalculationException {
        System.out.println("Cap prices:\n");
        System.out.println("Maturity      Simulation       Analytic        Deviation");
        double d = 0.0;
        for (int i = 2; i <= this.liborMarketModel.getNumberOfLibors() - 1; ++i) {
            double d2 = this.liborMarketModel.getLiborPeriod(i);
            System.out.print(formatterMaturity.format(d2) + "          ");
            double d3 = 0.05;
            double[] dArray = new TimeDiscretization(0.25, i - 2, 0.25).getAsDoubleArray();
            double[] dArray2 = new TimeDiscretization(0.5, i - 2, 0.25).getAsDoubleArray();
            double[] dArray3 = new double[i - 1];
            Arrays.fill(dArray3, d3);
            FlexiCap flexiCap = new FlexiCap(dArray, dArray2, dArray3, Integer.MAX_VALUE);
            double d4 = flexiCap.getValue(this.liborMarketModel);
            System.out.print(formatterValue.format(d4) + "          ");
            AnalyticModelInterface analyticModelInterface = new AnalyticModel();
            analyticModelInterface = analyticModelInterface.addCurves(this.forwardCurve);
            analyticModelInterface = analyticModelInterface.addCurves(this.discountCurve);
            analyticModelInterface = analyticModelInterface.addVolatilitySurfaces(this.capletVol);
            Calendar calendar = (Calendar)this.referenceDate.clone();
            calendar.add(2, 3);
            RegularSchedule regularSchedule = new RegularSchedule(new TimeDiscretization(0.25, i - 1, 0.25));
            Cap cap = new Cap(regularSchedule, this.forwardCurve.getName(), d3, false, this.discountCurve.getName(), "EUR");
            double d5 = cap.getValue(analyticModelInterface);
            System.out.print(formatterValue.format(d5) + "          ");
            double d6 = d4 - d5;
            System.out.println(formatterDeviation.format(d6) + "          ");
            d = Math.max(d, Math.abs(d6));
        }
        System.out.println("Maximum abs deviation: " + formatterDeviation.format(d));
        System.out.println("__________________________________________________________________________________________\n");
        Assert.assertEquals((String)"Deviation", (double)0.0, (double)d, (double)0.002);
    }
}

