/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.tests.montecarlo.assetderivativevaluation.products;

import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.assetderivativevaluation.AssetModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.assetderivativevaluation.MonteCarloBlackScholesModel;
import net.finmath.montecarlo.assetderivativevaluation.products.BlackScholesDeltaHedgedPortfolio;
import net.finmath.montecarlo.assetderivativevaluation.products.EuropeanOption;
import net.finmath.stochastic.RandomVariableInterface;
import net.finmath.time.TimeDiscretization;
import org.junit.Assert;
import org.junit.Test;

public class BlackScholesDeltaHedgedPortfolioTest {
    private final double initialValue = 1.0;
    private final double riskFreeRate = 0.05;
    private final double volatility = 0.3;
    private final int numberOfPaths = 100000;
    private final int numberOfTimeSteps = 1000;
    private final double timeHorizon = 5.0;
    private AssetModelMonteCarloSimulationInterface model = this.getModel();

    public AssetModelMonteCarloSimulationInterface getModel() {
        TimeDiscretization timeDiscretization = new TimeDiscretization(0.0, 1000, 0.005);
        MonteCarloBlackScholesModel monteCarloBlackScholesModel = new MonteCarloBlackScholesModel(timeDiscretization, 100000, 1.0, 0.05, 0.3);
        return monteCarloBlackScholesModel;
    }

    @Test
    public void testHedgePerformance() throws CalculationException {
        double d = 5.0;
        double d2 = 1.0 * Math.exp(0.05 * d);
        EuropeanOption europeanOption = new EuropeanOption(d, d2);
        BlackScholesDeltaHedgedPortfolio blackScholesDeltaHedgedPortfolio = new BlackScholesDeltaHedgedPortfolio(d, d2, 0.05, 0.3);
        RandomVariableInterface randomVariableInterface = europeanOption.getValue(d, this.model).sub(blackScholesDeltaHedgedPortfolio.getValue(d, this.model));
        double d3 = randomVariableInterface.getStandardDeviation();
        System.out.println("Hedge error (RMS): " + d3);
        Assert.assertTrue((d3 < 0.01 ? 1 : 0) != 0);
    }
}

