/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.tests.montecarlo;

import net.finmath.montecarlo.RandomVariable;
import net.finmath.stochastic.RandomVariableInterface;
import org.junit.Assert;
import org.junit.Test;

public class RandomVariableTests {
    @Test
    public void testRandomVariableDeterministc() {
        RandomVariableInterface randomVariableInterface = new RandomVariable(2.0);
        randomVariableInterface = randomVariableInterface.mult(2.0);
        randomVariableInterface = randomVariableInterface.add(1.0);
        randomVariableInterface = randomVariableInterface.squared();
        randomVariableInterface = randomVariableInterface.sub(4.0);
        Assert.assertTrue(((randomVariableInterface = randomVariableInterface.div(7.0)).getAverage() == 3.0 ? 1 : 0) != 0);
        Assert.assertTrue((randomVariableInterface.getVariance() == 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void testRandomVariableStochastic() {
        RandomVariableInterface randomVariableInterface = new RandomVariable(0.0, new double[]{-4.0, -2.0, 0.0, 2.0, 4.0});
        randomVariableInterface = randomVariableInterface.add(4.0);
        Assert.assertTrue(((randomVariableInterface = randomVariableInterface.div(2.0)).getAverage() == 2.0 ? 1 : 0) != 0);
        Assert.assertTrue((randomVariableInterface.getVariance() == 2.0 ? 1 : 0) != 0);
        RandomVariableInterface randomVariableInterface2 = new RandomVariable(3.0);
        randomVariableInterface2 = randomVariableInterface2.mult(randomVariableInterface);
        Assert.assertTrue((randomVariableInterface2.getAverage() == 6.0 ? 1 : 0) != 0);
        Assert.assertTrue((randomVariableInterface2.getVariance() == 18.0 ? 1 : 0) != 0);
    }

    @Test
    public void testRandomVariableArithmeticSqrtPow() {
        RandomVariable randomVariable = new RandomVariable(0.0, new double[]{3.0, 1.0, 0.0, 2.0, 4.0, 0.3333333333333333});
        RandomVariableInterface randomVariableInterface = randomVariable.sqrt().sub(randomVariable.pow(0.5));
        Assert.assertTrue((randomVariableInterface.getAverage() == 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((randomVariableInterface.getVariance() == 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void testRandomVariableArithmeticSquaredPow() {
        RandomVariable randomVariable = new RandomVariable(0.0, new double[]{3.0, 1.0, 0.0, 2.0, 4.0, 0.3333333333333333});
        RandomVariableInterface randomVariableInterface = randomVariable.squared().sub(randomVariable.pow(2.0));
        Assert.assertTrue((randomVariableInterface.getAverage() == 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((randomVariableInterface.getVariance() == 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void testRandomVariableStandardDeviation() {
        RandomVariable randomVariable = new RandomVariable(0.0, new double[]{3.0, 1.0, 0.0, 2.0, 4.0, 0.3333333333333333});
        double d = randomVariable.getStandardDeviation() - Math.sqrt(randomVariable.getVariance());
        Assert.assertTrue((d == 0.0 ? 1 : 0) != 0);
    }
}

