/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.tests.marketdata.curves;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Vector;
import net.finmath.marketdata.calibration.ParameterObjectInterface;
import net.finmath.marketdata.calibration.Solver;
import net.finmath.marketdata.model.AnalyticModel;
import net.finmath.marketdata.model.AnalyticModelInterface;
import net.finmath.marketdata.model.curves.Curve;
import net.finmath.marketdata.model.curves.CurveInterface;
import net.finmath.marketdata.model.curves.DiscountCurve;
import net.finmath.marketdata.model.curves.ForwardCurve;
import net.finmath.marketdata.model.curves.ForwardCurveFromDiscountCurve;
import net.finmath.marketdata.products.AnalyticProductInterface;
import net.finmath.marketdata.products.Swap;
import net.finmath.optimizer.SolverException;
import net.finmath.time.RegularSchedule;
import net.finmath.time.TimeDiscretization;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class CalibrationTest {
    static final double errorTolerance = 1.0E-14;
    final Curve.InterpolationMethod interpolationMethod;

    public CalibrationTest(Curve.InterpolationMethod interpolationMethod) {
        this.interpolationMethod = interpolationMethod;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> generateData() {
        return Arrays.asList({Curve.InterpolationMethod.LINEAR}, {Curve.InterpolationMethod.CUBIC_SPLINE}, {Curve.InterpolationMethod.AKIMA}, {Curve.InterpolationMethod.AKIMA_CONTINUOUS}, {Curve.InterpolationMethod.HARMONIC_SPLINE}, {Curve.InterpolationMethod.HARMONIC_SPLINE_WITH_MONOTONIC_FILTERING});
    }

    public static void main(String[] stringArray) throws SolverException {
        CalibrationTest calibrationTest = new CalibrationTest(Curve.InterpolationMethod.LINEAR);
        calibrationTest.testForwardCurveFromDiscountCurve();
        calibrationTest.testCurvesAndCalibration();
    }

    @Test
    public void testForwardCurveFromDiscountCurve() {
        DiscountCurve discountCurve = DiscountCurve.createDiscountCurveFromDiscountFactors("discountCurve", new double[]{0.0, 1.0, 2.0, 4.0, 5.0}, new double[]{1.0, 0.95, 0.9, 0.85, 0.8});
        ForwardCurveFromDiscountCurve forwardCurveFromDiscountCurve = new ForwardCurveFromDiscountCurve(discountCurve.getName(), null, null);
        AnalyticModel analyticModel = new AnalyticModel(new CurveInterface[]{discountCurve, forwardCurveFromDiscountCurve});
        System.out.println("Given a disocunt curve:");
        System.out.println(discountCurve.toString());
        double d = 1.0;
        double d2 = 0.5;
        double d3 = forwardCurveFromDiscountCurve.getForward(analyticModel, d, d2);
        System.out.println("Semi-annual forward with fixing in " + d + " calculated from that discount curve is " + d3);
        double d4 = (discountCurve.getDiscountFactor(analyticModel, d) / discountCurve.getDiscountFactor(analyticModel, d + d2) - 1.0) / d2;
        Assert.assertTrue((Math.abs(d3 - d4) < 1.0E-14 ? 1 : 0) != 0);
        System.out.println("__________________________________________________________________________________________\n");
    }

    @Test
    public void testCurvesAndCalibration() throws SolverException {
        Object object;
        System.out.println("Calibrating a discount curve from swaps (single-curve/self-discounting).");
        DiscountCurve discountCurve = DiscountCurve.createDiscountCurveFromDiscountFactors("discountCurve", new double[]{0.0, 1.0, 2.0, 4.0, 5.0}, new double[]{1.0, 0.95, 0.9, 0.85, 0.8}, this.interpolationMethod, Curve.ExtrapolationMethod.CONSTANT, Curve.InterpolationEntity.LOG_OF_VALUE);
        ForwardCurveFromDiscountCurve forwardCurveFromDiscountCurve = new ForwardCurveFromDiscountCurve(discountCurve.getName(), null, null);
        Vector<AnalyticProductInterface> vector = new Vector<AnalyticProductInterface>();
        vector.add(new Swap(new RegularSchedule(new TimeDiscretization(0.0, 1, 1.0)), null, 0.05, "discountCurve", new RegularSchedule(new TimeDiscretization(0.0, 1, 1.0)), forwardCurveFromDiscountCurve.getName(), 0.0, "discountCurve"));
        vector.add(new Swap(new RegularSchedule(new TimeDiscretization(0.0, 2, 1.0)), null, 0.04, "discountCurve", new RegularSchedule(new TimeDiscretization(0.0, 2, 1.0)), forwardCurveFromDiscountCurve.getName(), 0.0, "discountCurve"));
        vector.add(new Swap(new RegularSchedule(new TimeDiscretization(0.0, 8, 0.5)), null, 0.03, "discountCurve", new RegularSchedule(new TimeDiscretization(0.0, 8, 0.5)), forwardCurveFromDiscountCurve.getName(), 0.0, "discountCurve"));
        vector.add(new Swap(new RegularSchedule(new TimeDiscretization(0.0, 10, 0.5)), null, 0.04, "discountCurve", new RegularSchedule(new TimeDiscretization(0.0, 10, 0.5)), forwardCurveFromDiscountCurve.getName(), 0.0, "discountCurve"));
        AnalyticModel analyticModel = new AnalyticModel(new CurveInterface[]{discountCurve, forwardCurveFromDiscountCurve});
        HashSet<ParameterObjectInterface> hashSet = new HashSet<ParameterObjectInterface>();
        hashSet.add(discountCurve);
        Solver solver = new Solver(analyticModel, vector);
        AnalyticModelInterface analyticModelInterface = solver.getCalibratedModel(hashSet);
        System.out.println("The solver required " + solver.getIterations() + " iterations.");
        System.out.println("The best fit curve is:");
        System.out.println(analyticModelInterface.getCurve(discountCurve.getName()).toString());
        System.out.println("Calibration check:");
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < vector.size(); ++i) {
            object = vector.get(i);
            double d3 = object.getValue(d, analyticModelInterface);
            System.out.println("Calibration product " + i + ":\t" + d3);
            d2 += d3 * d3;
        }
        Assert.assertTrue(((d2 = Math.sqrt(d2)) < 1.0E-14 ? 1 : 0) != 0);
        System.out.println("__________________________________________________________________________________________\n");
        ForwardCurve forwardCurve = ForwardCurve.createForwardCurveFromForwards("forwardCurve", new double[]{0.005479452054794521, 1.0, 2.0, 3.0, 4.0}, new double[]{0.05, 0.05, 0.05, 0.05, 0.05}, analyticModel, discountCurve.getName(), 0.5);
        object = new AnalyticModel(new CurveInterface[]{discountCurve, forwardCurve});
        System.out.println("Calibrating a forward curve from swaps using the given discount curve.");
        Vector<AnalyticProductInterface> vector2 = new Vector<AnalyticProductInterface>();
        vector2.add(new Swap(new RegularSchedule(new TimeDiscretization(0.0, 1, 1.0)), null, 0.06, "discountCurve", new RegularSchedule(new TimeDiscretization(0.0, 1, 0.5)), "forwardCurve", 0.0, "discountCurve"));
        vector2.add(new Swap(new RegularSchedule(new TimeDiscretization(0.0, 2, 1.0)), null, 0.05, "discountCurve", new RegularSchedule(new TimeDiscretization(0.0, 2, 0.5)), "forwardCurve", 0.0, "discountCurve"));
        vector2.add(new Swap(new RegularSchedule(new TimeDiscretization(0.0, 6, 0.5)), null, 0.04, "discountCurve", new RegularSchedule(new TimeDiscretization(0.0, 6, 0.5)), "forwardCurve", 0.0, "discountCurve"));
        vector2.add(new Swap(new RegularSchedule(new TimeDiscretization(0.0, 8, 0.5)), null, 0.04, "discountCurve", new RegularSchedule(new TimeDiscretization(0.0, 8, 0.5)), "forwardCurve", 0.0, "discountCurve"));
        vector2.add(new Swap(new RegularSchedule(new TimeDiscretization(0.0, 10, 0.5)), null, 0.04, "discountCurve", new RegularSchedule(new TimeDiscretization(0.0, 10, 0.5)), "forwardCurve", 0.0, "discountCurve"));
        HashSet<ParameterObjectInterface> hashSet2 = new HashSet<ParameterObjectInterface>();
        hashSet2.add(forwardCurve);
        Solver solver2 = new Solver((AnalyticModelInterface)object, vector2);
        AnalyticModelInterface analyticModelInterface2 = solver2.getCalibratedModel(hashSet2);
        System.out.println("The solver required " + solver2.getIterations() + " iterations.");
        System.out.println("The best fit curve is:");
        System.out.println(analyticModelInterface2.getCurve(forwardCurve.getName()).toString());
        System.out.println("Calibration check:");
        double d4 = 0.0;
        for (int i = 0; i < vector2.size(); ++i) {
            AnalyticProductInterface analyticProductInterface = vector2.get(i);
            double d5 = analyticProductInterface.getValue(d, analyticModelInterface2);
            System.out.println("Calibration product " + i + ":\t" + d5);
            d4 += d5 * d5;
        }
        Assert.assertTrue(((d4 = Math.sqrt(d4)) < 1.0E-14 ? 1 : 0) != 0);
        System.out.println("__________________________________________________________________________________________\n");
    }
}

