/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Arrays;
import javax.swing.JTextField;

public class JNumberField
extends JTextField
implements ActionListener {
    private static final long serialVersionUID = -138039675088007707L;
    Number value = new Double(0.0);
    DecimalFormat formatter = new DecimalFormat("0.000");
    double[] admissibleValues = null;
    double lowerBound = -1.7976931348623157E308;
    double upperBound = Double.MAX_VALUE;

    public JNumberField() {
        this.addActionListener(this);
    }

    public JNumberField(double d, String string, ActionListener actionListener) {
        this.formatter = new DecimalFormat(string);
        this.addActionListener(actionListener);
        this.addActionListener(this);
        this.setValue(d);
    }

    public JNumberField(double d, DecimalFormat decimalFormat, ActionListener actionListener) {
        this.formatter = decimalFormat;
        this.addActionListener(actionListener);
        this.addActionListener(this);
        this.setValue(d);
    }

    public JNumberField(String string) {
        super(string);
        this.formatter = new DecimalFormat(string);
        this.addActionListener(this);
        this.setValue(0.0);
    }

    public Number getValue() {
        this.parseField();
        this.updateData();
        return this.value;
    }

    public void setValue(double d) {
        this.value = d;
        this.updateData();
    }

    public void setFromat(String string) {
        this.formatter = new DecimalFormat(string);
        this.updateData();
    }

    public void setRange(double d, double d2) {
        this.lowerBound = d;
        this.upperBound = d2;
        this.parseField();
        this.updateData();
    }

    public void setAdmissibleValues(double[] dArray) {
        this.admissibleValues = dArray;
    }

    public void add(double d) {
        this.setValue(this.getDoubleValue() + d);
    }

    public void addToAdmissibleValueIndex(int n) {
        int n2 = this.getAdmissibleValueIndex();
        if (n2 < 0) {
            return;
        }
        n2 = Math.max(0, Math.min(n2 + n, this.admissibleValues.length - 1));
        this.value = this.admissibleValues[n2];
        this.updateData();
    }

    public double getDoubleValue() {
        return this.getValue().doubleValue();
    }

    public int getIntValue() {
        return this.getValue().intValue();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.parseField();
        this.updateData();
    }

    private void parseField() {
        try {
            this.setValue(this.formatter.parse(this.getText()).doubleValue());
        }
        catch (ParseException parseException) {
            if (this.value != null) {
                this.setValue(this.value.doubleValue());
            }
            this.setValue(0.0);
        }
    }

    private void updateData() {
        int n;
        if (this.value == null) {
            this.parseField();
        }
        if ((n = this.getAdmissibleValueIndex()) >= 0) {
            this.value = this.admissibleValues[n];
        }
        this.value = new Double(Math.min(Math.max(this.lowerBound, this.value.doubleValue()), this.upperBound));
        this.setText(this.formatter.format(this.value));
        if (this.lowerBound != -1.7976931348623157E308 && this.upperBound != Double.MAX_VALUE) {
            this.setColumns(1 + Math.max(this.formatter.format(this.lowerBound).length(), this.formatter.format(this.upperBound).length()));
        } else {
            this.setColumns(1 + this.getText().length());
        }
    }

    private int getAdmissibleValueIndex() {
        if (this.admissibleValues != null && this.admissibleValues.length > 0) {
            int n = Arrays.binarySearch(this.admissibleValues, this.value.doubleValue());
            if (n < 0) {
                n = -n - 1;
            }
            if (n > this.admissibleValues.length) {
                --n;
            }
            return n;
        }
        return -1;
    }
}

