/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.rootfinder;

import java.text.DecimalFormat;
import net.finmath.rootfinder.BisectionSearch;
import net.finmath.rootfinder.NewtonsMethod;
import net.finmath.rootfinder.RiddersMethod;
import net.finmath.rootfinder.RootFinder;
import net.finmath.rootfinder.RootFinderWithDerivative;
import net.finmath.rootfinder.SecantMethod;

public class TestRootFinders {
    public static void main(String[] stringArray) {
        System.out.println("Applying root finders to x^3 + 2*y^2 + x + 1 = 0\n");
        System.out.println("Root finders without derivative:");
        System.out.println("--------------------------------");
        RootFinder rootFinder = new BisectionSearch(-10.0, 10.0);
        TestRootFinders.testRootFinder(rootFinder);
        rootFinder = new RiddersMethod(-10.0, 10.0);
        TestRootFinders.testRootFinder(rootFinder);
        rootFinder = new SecantMethod(2.0, 10.0);
        TestRootFinders.testRootFinder(rootFinder);
        System.out.println("");
        System.out.println("Root finders with    derivative:");
        System.out.println("--------------------------------");
        NewtonsMethod newtonsMethod = new NewtonsMethod(2.0);
        TestRootFinders.testRootFinderWithDerivative(newtonsMethod);
        newtonsMethod = new SecantMethod(2.0, 10.0);
        TestRootFinders.testRootFinderWithDerivative(newtonsMethod);
    }

    public static void testRootFinder(RootFinder rootFinder) {
        System.out.println("Testing " + rootFinder.getClass().getName() + ":");
        while (rootFinder.getAccuracy() > 1.0E-11 && !rootFinder.isDone()) {
            double d = rootFinder.getNextPoint();
            double d2 = d * d * d + d * d + d + 1.0;
            rootFinder.setValue(d2);
        }
        DecimalFormat decimalFormat = new DecimalFormat("0.00E00");
        System.out.print("Root......: " + decimalFormat.format(rootFinder.getBestPoint()) + "\t");
        System.out.print("Accuracy..: " + decimalFormat.format(rootFinder.getAccuracy()) + "\t");
        System.out.print("Iterations: " + rootFinder.getNumberOfIterations() + "\n");
    }

    public static void testRootFinderWithDerivative(RootFinderWithDerivative rootFinderWithDerivative) {
        System.out.println("Testing " + rootFinderWithDerivative.getClass().getName() + ":");
        while (rootFinderWithDerivative.getAccuracy() > 1.0E-11 && !rootFinderWithDerivative.isDone()) {
            double d = rootFinderWithDerivative.getNextPoint();
            double d2 = d * d * d + d * d + d + 1.0;
            double d3 = 3.0 * d * d + 2.0 * d + 1.0;
            rootFinderWithDerivative.setValueAndDerivative(d2, d3);
        }
        DecimalFormat decimalFormat = new DecimalFormat("0.00E00");
        System.out.print("Root......: " + decimalFormat.format(rootFinderWithDerivative.getBestPoint()) + "\t");
        System.out.print("Accuracy..: " + decimalFormat.format(rootFinderWithDerivative.getAccuracy()) + "\t");
        System.out.print("Iterations: " + rootFinderWithDerivative.getNumberOfIterations() + "\n");
    }
}

