/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.optimizer;

import net.finmath.optimizer.OptimizerFactoryInterface;
import net.finmath.optimizer.OptimizerInterface;
import net.finmath.optimizer.SolverException;
import org.apache.commons.math3.exception.MathIllegalStateException;
import org.apache.commons.math3.optim.ConvergenceChecker;
import org.apache.commons.math3.optim.OptimizationData;
import org.apache.commons.math3.optim.PointValuePair;
import org.apache.commons.math3.optim.SimplePointChecker;
import org.apache.commons.math3.optim.nonlinear.scalar.GoalType;
import org.apache.commons.math3.optim.nonlinear.scalar.noderiv.CMAESOptimizer;
import org.apache.commons.math3.random.MersenneTwister;
import org.apache.commons.math3.random.RandomGenerator;

public class OptimizerFactoryCMAES
implements OptimizerFactoryInterface {
    private final double accuracy;
    private final int maxIterations;
    private final double[] parameterLowerBound;
    private final double[] parameterUppderBound;
    private final double[] parameterStandardDeviation;

    public OptimizerFactoryCMAES(double d, int n, double[] dArray, double[] dArray2, double[] dArray3) {
        this.accuracy = d;
        this.maxIterations = n;
        this.parameterLowerBound = dArray;
        this.parameterUppderBound = dArray2;
        this.parameterStandardDeviation = dArray3;
    }

    public OptimizerFactoryCMAES(double d, int n, double[] dArray) {
        this.accuracy = d;
        this.maxIterations = n;
        this.parameterLowerBound = null;
        this.parameterUppderBound = null;
        this.parameterStandardDeviation = dArray;
    }

    public OptimizerFactoryCMAES(double d, int n) {
        this.accuracy = d;
        this.maxIterations = n;
        this.parameterLowerBound = null;
        this.parameterUppderBound = null;
        this.parameterStandardDeviation = null;
    }

    @Override
    public OptimizerInterface getOptimizer(OptimizerInterface.ObjectiveFunction objectiveFunction, double[] dArray) {
        return this.getOptimizer(objectiveFunction, dArray, null, null, null, null);
    }

    @Override
    public OptimizerInterface getOptimizer(OptimizerInterface.ObjectiveFunction objectiveFunction, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        return this.getOptimizer(objectiveFunction, dArray, dArray2, dArray3, null, dArray4);
    }

    @Override
    public OptimizerInterface getOptimizer(final OptimizerInterface.ObjectiveFunction objectiveFunction, final double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5) {
        final double[] dArray6 = new double[dArray5.length];
        final double[] dArray7 = this.parameterLowerBound != null ? this.parameterLowerBound : dArray2;
        final double[] dArray8 = this.parameterUppderBound != null ? this.parameterUppderBound : dArray3;
        final double[] dArray9 = this.parameterStandardDeviation != null ? this.parameterStandardDeviation : dArray4;
        return new OptimizerInterface(){
            private CMAESOptimizer optimizer;
            private PointValuePair result;

            @Override
            public double[] getBestFitParameters() {
                return this.result.getPoint();
            }

            @Override
            public double getRootMeanSquaredError() {
                return (Double)this.result.getValue();
            }

            @Override
            public int getIterations() {
                return this.optimizer != null ? this.optimizer.getIterations() : 0;
            }

            @Override
            public void run() throws SolverException {
                this.optimizer = new CMAESOptimizer(OptimizerFactoryCMAES.this.maxIterations, OptimizerFactoryCMAES.this.accuracy, true, 0, 0, (RandomGenerator)new MersenneTwister(3141), false, (ConvergenceChecker)new SimplePointChecker(0.0, 0.0)){

                    public double computeObjectiveValue(double[] dArray) {
                        try {
                            objectiveFunction.setValues(dArray, dArray6);
                        }
                        catch (SolverException solverException) {
                            return Double.NaN;
                        }
                        double d = 0.0;
                        for (double d2 : dArray6) {
                            d += d2 * d2;
                        }
                        return Math.sqrt(d);
                    }

                    public GoalType getGoalType() {
                        return GoalType.MINIMIZE;
                    }

                    public double[] getStartPoint() {
                        return dArray;
                    }

                    public double[] getLowerBound() {
                        return dArray7;
                    }

                    public double[] getUpperBound() {
                        return dArray8;
                    }
                };
                try {
                    this.result = this.optimizer.optimize(new OptimizationData[]{new CMAESOptimizer.PopulationSize((int)(4.0 + 3.0 * Math.log(dArray.length))), new CMAESOptimizer.Sigma(dArray9)});
                }
                catch (MathIllegalStateException mathIllegalStateException) {
                    new SolverException(mathIllegalStateException);
                }
            }
        };
    }
}

