/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.templatemethoddesign;

import net.finmath.montecarlo.BrownianMotion;
import net.finmath.montecarlo.BrownianMotionInterface;
import net.finmath.montecarlo.RandomVariable;
import net.finmath.stochastic.RandomVariableInterface;
import net.finmath.time.TimeDiscretizationInterface;

public abstract class LogNormalProcess {
    private BrownianMotionInterface brownianMotion;
    private RandomVariableInterface[][] discreteProcess = null;
    private RandomVariableInterface[] discreteProcessWeights = null;
    private TimeDiscretizationInterface timeDiscretization;
    private int numberOfComponents;
    private int numberOfFactors;
    private int numberOfPaths;
    private Scheme scheme = Scheme.EULER;

    public LogNormalProcess(int n, BrownianMotionInterface brownianMotionInterface) {
        this.timeDiscretization = brownianMotionInterface.getTimeDiscretization();
        this.numberOfComponents = n;
        this.numberOfFactors = brownianMotionInterface.getNumberOfFactors();
        this.numberOfPaths = brownianMotionInterface.getNumberOfPaths();
        this.brownianMotion = brownianMotionInterface;
    }

    public LogNormalProcess(TimeDiscretizationInterface timeDiscretizationInterface, int n, int n2) {
        this.timeDiscretization = timeDiscretizationInterface;
        this.numberOfComponents = n;
        this.numberOfFactors = 1;
        this.numberOfPaths = n2;
        this.brownianMotion = new BrownianMotion(timeDiscretizationInterface, this.numberOfFactors, n2, 3141);
    }

    public LogNormalProcess(TimeDiscretizationInterface timeDiscretizationInterface, int n, int n2, int n3, int n4) {
        this.timeDiscretization = timeDiscretizationInterface;
        this.numberOfComponents = n;
        this.numberOfFactors = n2;
        this.numberOfPaths = n3;
        this.brownianMotion = new BrownianMotion(timeDiscretizationInterface, n2, n3, n4);
    }

    public abstract RandomVariableInterface[] getInitialValue();

    public abstract RandomVariableInterface getDrift(int var1, int var2, RandomVariableInterface[] var3, RandomVariableInterface[] var4);

    public RandomVariableInterface[] getDrift(int n, RandomVariableInterface[] randomVariableInterfaceArray, RandomVariableInterface[] randomVariableInterfaceArray2) {
        RandomVariableInterface[] randomVariableInterfaceArray3 = new RandomVariableInterface[this.getNumberOfComponents()];
        for (int i = 0; i < this.getNumberOfComponents(); ++i) {
            randomVariableInterfaceArray3[i] = this.getDrift(n, i, randomVariableInterfaceArray, randomVariableInterfaceArray2);
        }
        return randomVariableInterfaceArray3;
    }

    public abstract RandomVariableInterface getFactorLoading(int var1, int var2, int var3, RandomVariableInterface[] var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RandomVariableInterface[] getProcessValue(int n) {
        LogNormalProcess logNormalProcess = this;
        synchronized (logNormalProcess) {
            if (this.discreteProcess == null || this.discreteProcess.length == 0) {
                this.doPrecalculateProcess();
            }
        }
        return this.discreteProcess[n];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RandomVariableInterface getProcessValue(int n, int n2) {
        if (n == 0) {
            return this.getInitialValue()[n2];
        }
        LogNormalProcess logNormalProcess = this;
        synchronized (logNormalProcess) {
            if (this.discreteProcess == null || this.discreteProcess.length == 0) {
                this.doPrecalculateProcess();
            }
        }
        return this.discreteProcess[n][n2];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RandomVariableInterface getMonteCarloWeights(int n) {
        LogNormalProcess logNormalProcess = this;
        synchronized (logNormalProcess) {
            if (this.discreteProcessWeights == null || this.discreteProcessWeights.length == 0) {
                this.doPrecalculateProcess();
            }
        }
        return this.discreteProcessWeights[n];
    }

    private void doPrecalculateProcess() {
        if (this.discreteProcess != null && this.discreteProcess.length != 0) {
            return;
        }
        this.discreteProcess = new RandomVariableInterface[this.timeDiscretization.getNumberOfTimeSteps() + 1][this.numberOfComponents];
        this.discreteProcessWeights = new RandomVariableInterface[this.getTimeDiscretization().getNumberOfTimeSteps() + 1];
        this.discreteProcessWeights[0] = new RandomVariable(0.0, 1.0 / (double)this.numberOfPaths);
        this.discreteProcess[0] = this.getInitialValue();
        for (int i = 1; i < this.timeDiscretization.getNumberOfTimeSteps() + 1; ++i) {
            Object object;
            Object object2;
            RandomVariableInterface randomVariableInterface;
            RandomVariableInterface randomVariableInterface2;
            double d = this.timeDiscretization.getTime(i) - this.timeDiscretization.getTime(i - 1);
            RandomVariableInterface[] randomVariableInterfaceArray = new RandomVariableInterface[this.numberOfComponents];
            RandomVariableInterface[] randomVariableInterfaceArray2 = new RandomVariableInterface[this.numberOfComponents];
            for (int j = this.numberOfComponents - 1; j >= 0; --j) {
                RandomVariableInterface randomVariableInterface3 = new RandomVariable(this.getTime(i - 1), 0.0);
                randomVariableInterface2 = new RandomVariable(this.getTime(i - 1), 0.0);
                for (int k = 0; k < this.numberOfFactors; ++k) {
                    randomVariableInterface = this.getFactorLoading(i - 1, k, j, null);
                    object2 = this.brownianMotion.getBrownianIncrement(i - 1, k);
                    randomVariableInterface3 = randomVariableInterface3.addProduct(randomVariableInterface, randomVariableInterface);
                    randomVariableInterface2 = randomVariableInterface2.addProduct(randomVariableInterface, (RandomVariableInterface)object2);
                }
                randomVariableInterfaceArray[j] = randomVariableInterface3;
                randomVariableInterfaceArray2[j] = randomVariableInterface2;
            }
            RandomVariableInterface[] randomVariableInterfaceArray3 = this.scheme == Scheme.PREDICTOR_USING_LASTREALIZATION ? this.getDrift(i - 1, this.discreteProcess[i - 1], this.discreteProcess[i]) : this.getDrift(i - 1, this.discreteProcess[i - 1], null);
            for (int j = this.numberOfComponents - 1; j >= 0; --j) {
                randomVariableInterface2 = randomVariableInterfaceArray3[j];
                RandomVariableInterface randomVariableInterface4 = randomVariableInterfaceArray[j];
                randomVariableInterface = randomVariableInterfaceArray2[j];
                if (randomVariableInterface2 == null) {
                    this.discreteProcess[i][j] = this.discreteProcess[i - 1][j];
                    continue;
                }
                object2 = new double[this.numberOfPaths];
                object = this.discreteProcess[i - 1][j];
                for (int k = 0; k < this.numberOfPaths; ++k) {
                    double d2 = object.get(k);
                    double d3 = randomVariableInterface2.get(k);
                    double d4 = randomVariableInterface4.get(k);
                    double d5 = randomVariableInterface.get(k);
                    object2[k] = d2 * Math.exp(d3 * d - 0.5 * d4 * d + d5);
                }
                this.discreteProcess[i][j] = new RandomVariable(this.getTime(i), (double[])object2);
            }
            if (this.scheme == Scheme.PREDICTOR_USING_EULERSTEP) {
                RandomVariable[] randomVariableArray = new RandomVariable[this.numberOfComponents];
                randomVariableInterfaceArray3 = this.getDrift(i - 1, this.discreteProcess[i - 1], this.discreteProcess[i]);
                for (int j = 0; j < this.numberOfComponents; ++j) {
                    RandomVariableInterface randomVariableInterface5 = randomVariableInterfaceArray3[j];
                    randomVariableInterface = randomVariableInterfaceArray[j];
                    object2 = randomVariableInterfaceArray2[j];
                    object = ((RandomVariable)this.discreteProcess[i][j]).getRealizations(this.numberOfPaths);
                    RandomVariableInterface randomVariableInterface6 = this.discreteProcess[i - 1][j];
                    for (int k = 0; k < this.numberOfPaths; ++k) {
                        double d6 = randomVariableInterface6.get(k);
                        double d7 = randomVariableInterface5.get(k);
                        double d8 = randomVariableInterface.get(k);
                        double d9 = object2.get(k);
                        object[k] = d6 * Math.exp(d7 * d - 0.5 * d8 * d + d9);
                    }
                    randomVariableArray[j] = new RandomVariable(this.getTime(i), (double[])object);
                }
                this.discreteProcess[i] = randomVariableArray;
            }
            this.discreteProcessWeights[i] = this.discreteProcessWeights[i - 1];
        }
    }

    public int getNumberOfComponents() {
        return this.numberOfComponents;
    }

    public int getNumberOfPaths() {
        return this.numberOfPaths;
    }

    public int getNumberOfFactors() {
        return this.numberOfFactors;
    }

    public TimeDiscretizationInterface getTimeDiscretization() {
        return this.timeDiscretization;
    }

    public double getTime(int n) {
        return this.timeDiscretization.getTime(n);
    }

    public int getTimeIndex(double d) {
        return this.timeDiscretization.getTimeIndex(d);
    }

    public BrownianMotionInterface getBrownianMotion() {
        return this.brownianMotion;
    }

    public Scheme getScheme() {
        return this.scheme;
    }

    protected synchronized void setBrownianMotion(BrownianMotionInterface brownianMotionInterface) {
        if (this.discreteProcessWeights != null && this.discreteProcessWeights.length != 0) {
            throw new RuntimeException("Tying to change lazy initialized immutable object after initialization.");
        }
        this.brownianMotion = brownianMotionInterface;
    }

    public synchronized void setScheme(Scheme scheme) {
        if (this.discreteProcessWeights != null && this.discreteProcessWeights.length != 0) {
            throw new RuntimeException("Tying to change lazy initialized immutable object after initialization.");
        }
        this.scheme = scheme;
    }

    public static enum Scheme {
        EULER,
        PREDICTOR_USING_EULERSTEP,
        PREDICTOR_USING_LASTREALIZATION;

    }
}

