/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.process;

import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import net.finmath.montecarlo.BrownianMotion;
import net.finmath.montecarlo.BrownianMotionInterface;
import net.finmath.montecarlo.process.AbstractProcess;
import net.finmath.optimizer.SolverException;
import net.finmath.stochastic.RandomVariableInterface;

public class ProcessEulerScheme
extends AbstractProcess {
    private BrownianMotionInterface brownianMotion;
    private Scheme scheme = Scheme.EULER;
    private ExecutorService executor;
    private transient RandomVariableInterface[][] discreteProcess = null;
    private transient RandomVariableInterface[] discreteProcessWeights;

    public ProcessEulerScheme(BrownianMotionInterface brownianMotionInterface) {
        super(brownianMotionInterface.getTimeDiscretization());
        this.brownianMotion = brownianMotionInterface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RandomVariableInterface getProcessValue(int n, int n2) {
        ProcessEulerScheme processEulerScheme = this;
        synchronized (processEulerScheme) {
            if (this.discreteProcess == null || this.discreteProcess.length == 0) {
                this.doPrecalculateProcess();
            }
        }
        if (this.discreteProcess[n][n2] == null) {
            throw new NullPointerException("Generation of process component " + n2 + " at time index " + n + " failed. Likely due to out of memory");
        }
        return this.discreteProcess[n][n2];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RandomVariableInterface getMonteCarloWeights(int n) {
        ProcessEulerScheme processEulerScheme = this;
        synchronized (processEulerScheme) {
            if (this.discreteProcessWeights == null || this.discreteProcessWeights.length == 0) {
                this.doPrecalculateProcess();
            }
        }
        return this.discreteProcessWeights[n];
    }

    private void doPrecalculateProcess() {
        int n;
        if (this.discreteProcess != null && this.discreteProcess.length != 0) {
            return;
        }
        int n2 = this.getNumberOfPaths();
        final int n3 = this.getNumberOfFactors();
        int n4 = this.getNumberOfComponents();
        this.discreteProcess = new RandomVariableInterface[this.getTimeDiscretization().getNumberOfTimeSteps() + 1][this.getNumberOfComponents()];
        this.discreteProcessWeights = new RandomVariableInterface[this.getTimeDiscretization().getNumberOfTimeSteps() + 1];
        this.discreteProcessWeights[0] = this.brownianMotion.getRandomVariableForConstant(1.0 / (double)n2);
        RandomVariableInterface[] randomVariableInterfaceArray = this.getInitialState();
        final RandomVariableInterface[] randomVariableInterfaceArray2 = new RandomVariableInterface[n4];
        for (n = 0; n < n4; ++n) {
            randomVariableInterfaceArray2[n] = randomVariableInterfaceArray[n];
            this.discreteProcess[0][n] = this.applyStateSpaceTransform(n, randomVariableInterfaceArray2[n]);
        }
        n = Math.min(Math.max(2 * Runtime.getRuntime().availableProcessors(), 1), n4);
        this.executor = Executors.newFixedThreadPool(n);
        for (int i = 1; i < this.getTimeDiscretization().getNumberOfTimeSteps() + 1; ++i) {
            Object object;
            RandomVariableInterface randomVariableInterface;
            int n5;
            final int n6 = i;
            final double d = this.getTime(n6) - this.getTime(n6 - 1);
            RandomVariableInterface[] randomVariableInterfaceArray3 = this.getDrift(n6 - 1, this.discreteProcess[n6 - 1], null);
            Vector<Future<RandomVariableInterface>> vector = new Vector<Future<RandomVariableInterface>>(n4);
            vector.setSize(n4);
            for (n5 = 0; n5 < n4; ++n5) {
                final int n7 = n5;
                randomVariableInterface = randomVariableInterfaceArray3[n7];
                if (randomVariableInterface == null) continue;
                object = new Callable<RandomVariableInterface>(){

                    @Override
                    public RandomVariableInterface call() throws SolverException {
                        RandomVariableInterface[] randomVariableInterfaceArray = ProcessEulerScheme.this.getFactorLoading(n6 - 1, n7, ProcessEulerScheme.this.discreteProcess[n6 - 1]);
                        if (randomVariableInterfaceArray == null) {
                            return null;
                        }
                        RandomVariableInterface randomVariableInterface5 = ProcessEulerScheme.this.brownianMotion.getRandomVariableForConstant(0.0);
                        for (int i = 0; i < n3; ++i) {
                            RandomVariableInterface randomVariableInterface2 = randomVariableInterfaceArray[i];
                            RandomVariableInterface randomVariableInterface3 = ProcessEulerScheme.this.brownianMotion.getBrownianIncrement(n6 - 1, i);
                            randomVariableInterface5 = randomVariableInterface5.addProduct(randomVariableInterface2, randomVariableInterface3);
                        }
                        RandomVariableInterface randomVariableInterface4 = randomVariableInterface5;
                        if (randomVariableInterface != null) {
                            randomVariableInterface4 = randomVariableInterface4.addProduct(randomVariableInterface, d);
                        }
                        randomVariableInterfaceArray2[n7] = randomVariableInterfaceArray2[n7].add(randomVariableInterface4);
                        return ProcessEulerScheme.this.applyStateSpaceTransform(n7, randomVariableInterfaceArray2[n7]);
                    }
                };
                vector.set(n7, this.executor.submit(object));
            }
            for (n5 = 0; n5 < n4; ++n5) {
                try {
                    Future future = (Future)vector.get(n5);
                    if (future != null) {
                        this.discreteProcess[n6][n5] = (RandomVariableInterface)future.get();
                        continue;
                    }
                    this.discreteProcess[n6][n5] = null;
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                    continue;
                }
                catch (ExecutionException executionException) {
                    executionException.printStackTrace();
                }
            }
            if (this.scheme == Scheme.PREDICTOR_CORRECTOR) {
                RandomVariableInterface[] randomVariableInterfaceArray4 = this.getDrift(n6 - 1, this.discreteProcess[n6], null);
                for (int j = 0; j < this.getNumberOfComponents(); ++j) {
                    randomVariableInterface = randomVariableInterfaceArray4[j];
                    object = randomVariableInterfaceArray3[j];
                    if (randomVariableInterface == null || object == null) continue;
                    RandomVariableInterface randomVariableInterface2 = randomVariableInterface.sub((RandomVariableInterface)object).div(2.0).mult(d);
                    randomVariableInterfaceArray2[j] = randomVariableInterfaceArray2[j].add(randomVariableInterface2);
                    this.discreteProcess[n6][j] = this.applyStateSpaceTransform(j, randomVariableInterfaceArray2[j]);
                }
            }
            this.discreteProcessWeights[n6] = this.discreteProcessWeights[n6 - 1];
        }
        try {
            this.executor.shutdown();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    private synchronized void reset() {
        this.discreteProcess = null;
        this.discreteProcessWeights = null;
    }

    @Override
    public int getNumberOfPaths() {
        return this.brownianMotion.getNumberOfPaths();
    }

    @Override
    public int getNumberOfFactors() {
        return this.brownianMotion.getNumberOfFactors();
    }

    @Deprecated
    public void setSeed(int n) {
        this.setBrownianMotion(new BrownianMotion(this.brownianMotion.getTimeDiscretization(), this.brownianMotion.getNumberOfFactors(), this.brownianMotion.getNumberOfPaths(), n));
        this.reset();
    }

    @Override
    public BrownianMotionInterface getBrownianMotion() {
        return this.brownianMotion;
    }

    @Deprecated
    public void setBrownianMotion(BrownianMotion brownianMotion) {
        this.brownianMotion = brownianMotion;
        this.reset();
    }

    public Scheme getScheme() {
        return this.scheme;
    }

    @Deprecated
    public void setScheme(Scheme scheme) {
        this.scheme = scheme;
        this.reset();
    }

    @Override
    public ProcessEulerScheme clone() {
        return new ProcessEulerScheme(this.getBrownianMotion());
    }

    @Override
    public Object getCloneWithModifiedSeed(int n) {
        return new ProcessEulerScheme(this.getBrownianMotion().getCloneWithModifiedSeed(n));
    }

    public static enum Scheme {
        EULER,
        PREDICTOR_CORRECTOR;

    }
}

