/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products.indices;

import java.util.Calendar;
import java.util.Set;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.interestrate.products.indices.AbstractIndex;
import net.finmath.stochastic.RandomVariableInterface;
import net.finmath.time.daycount.DayCountConvention_ACT_365;

public class TimeDiscreteEndOfMonthIndex
extends AbstractIndex {
    private static final long serialVersionUID = -490057583438933158L;
    private final AbstractIndex baseIndex;
    private final int fixingOffsetMonths;

    public TimeDiscreteEndOfMonthIndex(String string, AbstractIndex abstractIndex, int n) {
        super(string);
        this.baseIndex = abstractIndex;
        this.fixingOffsetMonths = n;
    }

    @Override
    public RandomVariableInterface getValue(double d, LIBORModelMonteCarloSimulationInterface lIBORModelMonteCarloSimulationInterface) throws CalculationException {
        Calendar calendar = lIBORModelMonteCarloSimulationInterface.getModel().getForwardRateCurve().getReferenceDate();
        Calendar calendar2 = (Calendar)calendar.clone();
        calendar2.add(6, (int)Math.round(d * 365.0));
        calendar2.set(5, 1);
        calendar2.add(2, this.fixingOffsetMonths);
        calendar2.set(5, calendar2.getActualMaximum(5));
        double d2 = new DayCountConvention_ACT_365().getDaycountFraction(calendar, calendar2);
        return this.baseIndex.getValue(d2, lIBORModelMonteCarloSimulationInterface);
    }

    @Override
    public Set<String> queryUnderlyings() {
        return this.baseIndex.queryUnderlyings();
    }

    @Override
    public String toString() {
        return "TimeDiscreteEndOfMonthIndex [baseIndex=" + this.baseIndex + ", fixingOffsetMonths=" + this.fixingOffsetMonths + "]";
    }
}

