/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products.indices;

import java.util.Set;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.interestrate.products.components.AbstractProductComponent;
import net.finmath.montecarlo.interestrate.products.indices.AbstractIndex;
import net.finmath.stochastic.RandomVariableInterface;

public class PowIndex
extends AbstractIndex {
    private static final long serialVersionUID = -1512137372132830198L;
    private final AbstractProductComponent index;
    private final double exponent;

    public PowIndex(AbstractProductComponent abstractProductComponent, double d) {
        this.index = abstractProductComponent;
        this.exponent = d;
    }

    @Override
    public RandomVariableInterface getValue(double d, LIBORModelMonteCarloSimulationInterface lIBORModelMonteCarloSimulationInterface) throws CalculationException {
        return this.index.getValue(d, lIBORModelMonteCarloSimulationInterface).pow(this.exponent);
    }

    @Override
    public Set<String> queryUnderlyings() {
        return this.index.queryUnderlyings();
    }

    @Override
    public String toString() {
        return "PowIndex [index=" + this.index + ", exponent=" + this.exponent + "]";
    }
}

