/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products.indices;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import net.finmath.exception.CalculationException;
import net.finmath.marketdata.model.AnalyticModel;
import net.finmath.marketdata.model.AnalyticModelInterface;
import net.finmath.marketdata.model.curves.AbstractCurve;
import net.finmath.marketdata.model.curves.CurveInterface;
import net.finmath.marketdata.model.curves.DiscountCurveFromForwardCurve;
import net.finmath.marketdata.model.curves.DiscountCurveInterface;
import net.finmath.marketdata.model.curves.DiscountCurveNelsonSiegelSvensson;
import net.finmath.marketdata.model.curves.ForwardCurve;
import net.finmath.marketdata.model.curves.ForwardCurveInterface;
import net.finmath.marketdata.model.curves.ForwardCurveNelsonSiegelSvensson;
import net.finmath.montecarlo.BrownianMotion;
import net.finmath.montecarlo.interestrate.LIBORMarketModel;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulation;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.interestrate.modelplugins.LIBORCorrelationModelExponentialDecay;
import net.finmath.montecarlo.interestrate.modelplugins.LIBORCovarianceModelFromVolatilityAndCorrelation;
import net.finmath.montecarlo.interestrate.modelplugins.LIBORVolatilityModelFromGivenMatrix;
import net.finmath.montecarlo.interestrate.products.components.AbstractProductComponent;
import net.finmath.montecarlo.interestrate.products.components.Notional;
import net.finmath.montecarlo.interestrate.products.components.Period;
import net.finmath.montecarlo.interestrate.products.components.ProductCollection;
import net.finmath.montecarlo.interestrate.products.indices.LIBORIndex;
import net.finmath.montecarlo.process.ProcessEulerScheme;
import net.finmath.time.TimeDiscretization;
import net.finmath.time.businessdaycalendar.BusinessdayCalendarExcludingTARGETHolidays;
import net.finmath.time.businessdaycalendar.BusinessdayCalendarInterface;
import net.finmath.time.daycount.DayCountConventionInterface;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class LIBORIndexTest {
    private final int numberOfFactors = 5;
    private final double correlationDecayParam = 0.05;
    private double[] periodStarts = new double[]{2.0, 2.0, 2.0, 2.5, 2.5, 2.5, 2.0, 2.0, 2.25, 4.0};
    private double[] periodEnds = new double[]{2.5, 2.25, 3.0, 3.0, 3.25, 3.5, 4.0, 5.0, 2.5, 5.0};
    private double[] tolerance = new double[]{3.0E-4, 3.0E-4, 3.0E-4, 3.0E-4, 3.0E-4, 3.0E-4, 3.0E-4, 3.0E-4, 3.0E-4, 3.0E-4};
    private LIBORModelMonteCarloSimulationInterface liborMarketModel;

    @Parameterized.Parameters
    public static Collection<Object[]> generateData() {
        return Arrays.asList({new Integer(1000), CurveSetup.NSS}, {new Integer(2000), CurveSetup.NSS}, {new Integer(4000), CurveSetup.NSS}, {new Integer(8000), CurveSetup.NSS}, {new Integer(10000), CurveSetup.NSS}, {new Integer(20000), CurveSetup.NSS}, {new Integer(40000), CurveSetup.NSS}, {new Integer(80000), CurveSetup.NSS}, {new Integer(100000), CurveSetup.NSS}, {new Integer(200000), CurveSetup.NSS}, {new Integer(1000), CurveSetup.DISCRETE}, {new Integer(2000), CurveSetup.DISCRETE}, {new Integer(4000), CurveSetup.DISCRETE}, {new Integer(8000), CurveSetup.DISCRETE}, {new Integer(10000), CurveSetup.DISCRETE}, {new Integer(20000), CurveSetup.DISCRETE}, {new Integer(40000), CurveSetup.DISCRETE}, {new Integer(80000), CurveSetup.DISCRETE}, {new Integer(100000), CurveSetup.DISCRETE}, {new Integer(200000), CurveSetup.DISCRETE});
    }

    public LIBORIndexTest(Integer n, CurveSetup curveSetup) throws CalculationException {
        this.liborMarketModel = LIBORIndexTest.createLIBORMarketModel(curveSetup, LIBORMarketModel.Measure.SPOT, n, 5, 0.05);
    }

    @Test
    public void testSinglePeriods() throws CalculationException {
        DecimalFormat decimalFormat = new DecimalFormat("0.00");
        DecimalFormat decimalFormat2 = new DecimalFormat("0.000000");
        for (int i = 0; i < this.periodStarts.length; ++i) {
            double d = this.periodStarts[i];
            double d2 = this.periodEnds[i];
            double d3 = d2 - d;
            LIBORIndex lIBORIndex = new LIBORIndex(0.0, d3);
            Period period = new Period(d, d2, d, d2, new Notional(1.0), lIBORIndex, d3, true, true, false);
            double d4 = period.getValue(this.liborMarketModel);
            double d5 = this.tolerance[i] / Math.sqrt((double)this.liborMarketModel.getNumberOfPaths() / 100000.0);
            System.out.println(decimalFormat.format(d) + "\t" + decimalFormat.format(d2) + "\t" + decimalFormat2.format(d4) + "\t" + decimalFormat2.format(d5));
            Assert.assertTrue((Math.abs(d4) < d5 ? 1 : 0) != 0);
        }
        System.out.println();
    }

    @Test
    public void testMultiPeriodFloater() throws CalculationException {
        double d;
        double d2;
        double d3 = 0.002;
        ArrayList<AbstractProductComponent> arrayList = new ArrayList<AbstractProductComponent>();
        for (int i = 0; i < 10; ++i) {
            d2 = 2.0 + 0.5 * (double)i;
            d = 2.0 + 0.5 * (double)(i + 1);
            double d4 = d - d2;
            LIBORIndex lIBORIndex = new LIBORIndex(0.0, d4);
            Period period = new Period(d2, d, d2, d, new Notional(1.0), lIBORIndex, d4, true, true, false);
            arrayList.add(period);
        }
        ProductCollection productCollection = new ProductCollection(arrayList);
        d2 = productCollection.getValue(this.liborMarketModel);
        d = d3 / Math.sqrt((double)this.liborMarketModel.getNumberOfPaths() / 100000.0);
        DecimalFormat decimalFormat = new DecimalFormat("0.000000");
        System.out.println(decimalFormat.format(d2) + "\t" + decimalFormat.format(d));
        Assert.assertEquals((String)"Deviation", (double)0.0, (double)d2, (double)d);
    }

    public static LIBORModelMonteCarloSimulationInterface createLIBORMarketModel(CurveSetup curveSetup, LIBORMarketModel.Measure measure, int n, int n2, double d) throws CalculationException {
        AbstractCurve abstractCurve;
        Object object;
        AbstractCurve abstractCurve2;
        double d2 = 0.5;
        double d3 = 20.0;
        TimeDiscretization timeDiscretization = new TimeDiscretization(0.0, (int)(d3 / d2), d2);
        GregorianCalendar gregorianCalendar = new GregorianCalendar(2014, 8, 16);
        double[] dArray = new double[]{0.02, -0.01, 0.16, -0.17, 4.5, 3.5};
        switch (curveSetup) {
            case NSS: {
                abstractCurve2 = new DiscountCurveNelsonSiegelSvensson("EUR Curve", gregorianCalendar, dArray, 1.0);
                object = "6M";
                BusinessdayCalendarExcludingTARGETHolidays businessdayCalendarExcludingTARGETHolidays = new BusinessdayCalendarExcludingTARGETHolidays();
                BusinessdayCalendarInterface.DateRollConvention dateRollConvention = BusinessdayCalendarInterface.DateRollConvention.MODIFIED_FOLLOWING;
                DayCountConventionInterface dayCountConventionInterface = null;
                abstractCurve = new ForwardCurveNelsonSiegelSvensson("EUR Curve", gregorianCalendar, (String)object, businessdayCalendarExcludingTARGETHolidays, dateRollConvention, dayCountConventionInterface, dArray, 1.0, 0.0);
                break;
            }
            case DISCRETE: {
                abstractCurve = ForwardCurve.createForwardCurveFromForwards("forwardCurve", new double[]{0.5, 1.0, 2.0, 5.0, 40.0}, new double[]{0.02, 0.025, 0.03, 0.035, 0.04}, d2);
                abstractCurve2 = new DiscountCurveFromForwardCurve((ForwardCurveInterface)((Object)abstractCurve));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown curve setup: " + curveSetup.toString());
            }
        }
        object = new AnalyticModel(new CurveInterface[]{abstractCurve2, abstractCurve});
        double d4 = 20.0;
        double d5 = 0.5;
        TimeDiscretization timeDiscretization2 = new TimeDiscretization(0.0, (int)(d4 / d5), d5);
        double[][] dArray2 = new double[timeDiscretization2.getNumberOfTimeSteps()][timeDiscretization.getNumberOfTimeSteps()];
        for (int i = 0; i < dArray2.length; ++i) {
            for (int j = 0; j < dArray2[i].length; ++j) {
                double d6 = timeDiscretization2.getTime(i);
                double d7 = timeDiscretization.getTime(j);
                double d8 = d7 - d6;
                double d9 = d8 <= 0.0 ? 0.0 : 0.3 + 0.2 * Math.exp(-0.25 * d8);
                dArray2[i][j] = d9;
            }
        }
        LIBORVolatilityModelFromGivenMatrix lIBORVolatilityModelFromGivenMatrix = new LIBORVolatilityModelFromGivenMatrix(timeDiscretization2, timeDiscretization, dArray2);
        LIBORCorrelationModelExponentialDecay lIBORCorrelationModelExponentialDecay = new LIBORCorrelationModelExponentialDecay(timeDiscretization2, timeDiscretization, n2, d);
        LIBORCovarianceModelFromVolatilityAndCorrelation lIBORCovarianceModelFromVolatilityAndCorrelation = new LIBORCovarianceModelFromVolatilityAndCorrelation(timeDiscretization2, timeDiscretization, lIBORVolatilityModelFromGivenMatrix, lIBORCorrelationModelExponentialDecay);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("measure", measure.name());
        hashMap.put("stateSpace", LIBORMarketModel.StateSpace.LOGNORMAL.name());
        LIBORMarketModel.CalibrationItem[] calibrationItemArray = new LIBORMarketModel.CalibrationItem[]{};
        LIBORMarketModel lIBORMarketModel = new LIBORMarketModel(timeDiscretization, (AnalyticModelInterface)object, (ForwardCurveInterface)((Object)abstractCurve), (DiscountCurveInterface)((Object)abstractCurve2), lIBORCovarianceModelFromVolatilityAndCorrelation, calibrationItemArray, (Map<String, ?>)hashMap);
        ProcessEulerScheme processEulerScheme = new ProcessEulerScheme(new BrownianMotion(timeDiscretization2, n2, n, 8787));
        return new LIBORModelMonteCarloSimulation(lIBORMarketModel, processEulerScheme);
    }

    public static enum CurveSetup {
        NSS,
        DISCRETE;

    }
}

