/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products.indices;

import java.util.HashSet;
import java.util.Set;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.interestrate.products.indices.AbstractIndex;
import net.finmath.stochastic.RandomVariableInterface;

public class LIBORIndex
extends AbstractIndex {
    private static final long serialVersionUID = 1L;
    private final double periodStartOffset;
    private final double periodLength;

    public LIBORIndex(String string, double d, double d2) {
        super(string);
        this.periodStartOffset = d;
        this.periodLength = d2;
    }

    public LIBORIndex(double d, double d2) {
        this(null, d, d2);
    }

    @Override
    public RandomVariableInterface getValue(double d, LIBORModelMonteCarloSimulationInterface lIBORModelMonteCarloSimulationInterface) throws CalculationException {
        if (lIBORModelMonteCarloSimulationInterface.getModel().getForwardRateCurve().getName() != null && this.getName() != null && !lIBORModelMonteCarloSimulationInterface.getModel().getForwardRateCurve().getName().contains(this.getName())) {
            throw new IllegalArgumentException("No curve for index " + this.getName() + " found in model.");
        }
        RandomVariableInterface randomVariableInterface = lIBORModelMonteCarloSimulationInterface.getLIBOR(d, d + this.periodStartOffset, d + this.periodStartOffset + this.periodLength);
        return randomVariableInterface;
    }

    public double getPeriodStartOffset() {
        return this.periodStartOffset;
    }

    public double getPeriodLength() {
        return this.periodLength;
    }

    @Override
    public Set<String> queryUnderlyings() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(this.getName());
        return hashSet;
    }

    @Override
    public String toString() {
        return "LIBORIndex [periodStartOffset=" + this.periodStartOffset + ", periodLength=" + this.periodLength + ", toString()=" + super.toString() + "]";
    }
}

