/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products.indices;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.interestrate.products.indices.AbstractIndex;
import net.finmath.stochastic.RandomVariableInterface;

public class ConstantMaturitySwaprate
extends AbstractIndex {
    private static final long serialVersionUID = -5353191308059733179L;
    final double fixingOffset;
    final double[] periodLengths;

    public ConstantMaturitySwaprate(String string, String string2, double d, double[] dArray) {
        super(string, string2);
        this.fixingOffset = d;
        this.periodLengths = dArray;
    }

    public ConstantMaturitySwaprate(double d, double[] dArray) {
        this(null, null, d, dArray);
    }

    public ConstantMaturitySwaprate(double[] dArray) {
        this(0.0, dArray);
    }

    public ConstantMaturitySwaprate(String string, String string2, double d, double d2, double d3) {
        super(string, string2);
        this.fixingOffset = d;
        int n = (int)(d2 / d3 + 0.5);
        if ((double)n * d3 != d2) {
            throw new IllegalArgumentException("matruity not divisible by periodLength");
        }
        this.periodLengths = new double[n];
        Arrays.fill(this.periodLengths, d3);
    }

    public ConstantMaturitySwaprate(double d, double d2, double d3) {
        this(null, null, d, d2, d3);
    }

    public ConstantMaturitySwaprate(double d, double d2) {
        this(0.0, d, d2);
    }

    @Override
    public RandomVariableInterface getValue(double d, LIBORModelMonteCarloSimulationInterface lIBORModelMonteCarloSimulationInterface) throws CalculationException {
        RandomVariableInterface randomVariableInterface;
        RandomVariableInterface[] randomVariableInterfaceArray = new RandomVariableInterface[this.periodLengths.length];
        double d2 = d + this.fixingOffset;
        for (int i = 0; i < this.periodLengths.length; ++i) {
            randomVariableInterfaceArray[i] = lIBORModelMonteCarloSimulationInterface.getLIBOR(d + this.fixingOffset, d2, d2 + this.periodLengths[i]);
            d2 += this.periodLengths[i];
        }
        RandomVariableInterface randomVariableInterface2 = lIBORModelMonteCarloSimulationInterface.getRandomVariableForConstant(1.0);
        RandomVariableInterface randomVariableInterface3 = lIBORModelMonteCarloSimulationInterface.getRandomVariableForConstant(this.periodLengths[this.periodLengths.length - 1]);
        for (int i = this.periodLengths.length - 1; i >= 1; --i) {
            randomVariableInterface = randomVariableInterfaceArray[i].mult(this.periodLengths[i]).add(1.0);
            randomVariableInterface2 = randomVariableInterface2.mult(randomVariableInterface);
            randomVariableInterface3 = randomVariableInterface3.addProduct(randomVariableInterface2, this.periodLengths[i]);
        }
        RandomVariableInterface randomVariableInterface4 = randomVariableInterfaceArray[0].mult(this.periodLengths[0]).add(1.0);
        randomVariableInterface2 = randomVariableInterface2.mult(randomVariableInterface4);
        randomVariableInterface = randomVariableInterface2.sub(1.0).div(randomVariableInterface3);
        return randomVariableInterface;
    }

    @Override
    public Set<String> queryUnderlyings() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(this.getName());
        return hashSet;
    }

    @Override
    public String toString() {
        return "ConstantMaturitySwaprate [fixingOffset=" + this.fixingOffset + ", periodLengths=" + Arrays.toString(this.periodLengths) + "]";
    }
}

