/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products.components;

import java.util.ArrayList;
import java.util.Set;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.RandomVariable;
import net.finmath.montecarlo.conditionalexpectation.MonteCarloConditionalExpectationRegression;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.interestrate.products.components.AbstractProductComponent;
import net.finmath.stochastic.RandomVariableInterface;

public class IndexedValue
extends AbstractProductComponent {
    private static final long serialVersionUID = -7268432817913776974L;
    private double exerciseDate;
    private AbstractProductComponent index;
    private AbstractProductComponent underlying;

    public IndexedValue(double d, AbstractProductComponent abstractProductComponent, AbstractProductComponent abstractProductComponent2) {
        this.exerciseDate = d;
        this.index = abstractProductComponent;
        this.underlying = abstractProductComponent2;
    }

    @Override
    public String getCurrency() {
        return this.underlying.getCurrency();
    }

    @Override
    public Set<String> queryUnderlyings() {
        Set<String> set = this.underlying.queryUnderlyings();
        Set<String> set2 = this.index.queryUnderlyings();
        if (set == null && set2 == null) {
            return null;
        }
        if (set != null && set2 == null) {
            return set;
        }
        if (set == null && set2 != null) {
            return set2;
        }
        set.addAll(set2);
        return set;
    }

    @Override
    public RandomVariableInterface getValue(double d, LIBORModelMonteCarloSimulationInterface lIBORModelMonteCarloSimulationInterface) throws CalculationException {
        Object object;
        double d2 = Math.max(d, this.exerciseDate);
        RandomVariableInterface randomVariableInterface = this.underlying.getValue(d2, lIBORModelMonteCarloSimulationInterface);
        RandomVariableInterface randomVariableInterface2 = this.index.getValue(this.exerciseDate, lIBORModelMonteCarloSimulationInterface);
        if (randomVariableInterface2.getFiltrationTime() > this.exerciseDate && this.exerciseDate > d) {
            object = new MonteCarloConditionalExpectationRegression(this.getRegressionBasisFunctions(this.exerciseDate, lIBORModelMonteCarloSimulationInterface));
            randomVariableInterface2 = ((MonteCarloConditionalExpectationRegression)object).getConditionalExpectation(randomVariableInterface2);
        }
        randomVariableInterface = randomVariableInterface.mult(randomVariableInterface2);
        if (d != d2) {
            object = lIBORModelMonteCarloSimulationInterface.getNumeraire(d);
            RandomVariableInterface randomVariableInterface3 = lIBORModelMonteCarloSimulationInterface.getNumeraire(d2);
            randomVariableInterface = randomVariableInterface.div(randomVariableInterface3).mult((RandomVariableInterface)object);
        }
        return randomVariableInterface;
    }

    private RandomVariableInterface[] getRegressionBasisFunctions(double d, LIBORModelMonteCarloSimulationInterface lIBORModelMonteCarloSimulationInterface) throws CalculationException {
        ArrayList<RandomVariableInterface> arrayList = new ArrayList<RandomVariableInterface>();
        RandomVariableInterface randomVariableInterface = new RandomVariable(d, 1.0);
        arrayList.add(randomVariableInterface);
        randomVariableInterface = new RandomVariable(d, 1.0);
        int n = lIBORModelMonteCarloSimulationInterface.getLiborPeriodIndex(d);
        int n2 = n + 1;
        double d2 = lIBORModelMonteCarloSimulationInterface.getLiborPeriod(n2) - lIBORModelMonteCarloSimulationInterface.getLiborPeriod(n);
        RandomVariableInterface randomVariableInterface2 = lIBORModelMonteCarloSimulationInterface.getLIBOR(d, lIBORModelMonteCarloSimulationInterface.getLiborPeriod(n), lIBORModelMonteCarloSimulationInterface.getLiborPeriod(n2));
        randomVariableInterface = randomVariableInterface.discount(randomVariableInterface2, d2);
        arrayList.add(randomVariableInterface);
        randomVariableInterface = randomVariableInterface.discount(randomVariableInterface2, d2);
        arrayList.add(randomVariableInterface);
        randomVariableInterface = new RandomVariable(d, 1.0);
        n = lIBORModelMonteCarloSimulationInterface.getLiborPeriodIndex(d);
        n2 = (n + lIBORModelMonteCarloSimulationInterface.getNumberOfLibors()) / 2;
        d2 = lIBORModelMonteCarloSimulationInterface.getLiborPeriod(n2) - lIBORModelMonteCarloSimulationInterface.getLiborPeriod(n);
        randomVariableInterface2 = lIBORModelMonteCarloSimulationInterface.getLIBOR(d, lIBORModelMonteCarloSimulationInterface.getLiborPeriod(n), lIBORModelMonteCarloSimulationInterface.getLiborPeriod(n2));
        randomVariableInterface = randomVariableInterface.discount(randomVariableInterface2, d2);
        arrayList.add(randomVariableInterface);
        randomVariableInterface = randomVariableInterface.discount(randomVariableInterface2, d2);
        arrayList.add(randomVariableInterface);
        randomVariableInterface = randomVariableInterface.discount(randomVariableInterface2, d2);
        arrayList.add(randomVariableInterface);
        randomVariableInterface = new RandomVariable(d, 1.0);
        n = lIBORModelMonteCarloSimulationInterface.getLiborPeriodIndex(d);
        n2 = lIBORModelMonteCarloSimulationInterface.getNumberOfLibors();
        d2 = lIBORModelMonteCarloSimulationInterface.getLiborPeriod(n2) - lIBORModelMonteCarloSimulationInterface.getLiborPeriod(n);
        randomVariableInterface2 = lIBORModelMonteCarloSimulationInterface.getLIBOR(d, lIBORModelMonteCarloSimulationInterface.getLiborPeriod(n), lIBORModelMonteCarloSimulationInterface.getLiborPeriod(n2));
        randomVariableInterface = randomVariableInterface.discount(randomVariableInterface2, d2);
        arrayList.add(randomVariableInterface);
        randomVariableInterface = randomVariableInterface.discount(randomVariableInterface2, d2);
        arrayList.add(randomVariableInterface);
        return arrayList.toArray(new RandomVariableInterface[0]);
    }
}

