/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.finmath.functions.AnalyticFormulas;
import net.finmath.marketdata.model.AnalyticModel;
import net.finmath.marketdata.model.curves.CurveInterface;
import net.finmath.marketdata.model.curves.DiscountCurveFromForwardCurve;
import net.finmath.marketdata.model.curves.DiscountCurveInterface;
import net.finmath.marketdata.model.curves.ForwardCurveInterface;
import net.finmath.marketdata.products.Swap;
import net.finmath.marketdata.products.SwapAnnuity;
import net.finmath.montecarlo.RandomVariable;
import net.finmath.montecarlo.interestrate.LIBORMarketModel;
import net.finmath.montecarlo.interestrate.LIBORMarketModelInterface;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.interestrate.products.AbstractLIBORMonteCarloProduct;
import net.finmath.stochastic.RandomVariableInterface;
import net.finmath.time.TimeDiscretization;
import net.finmath.time.TimeDiscretizationInterface;

public class SwaptionAnalyticApproximationRebonato
extends AbstractLIBORMonteCarloProduct {
    private final double swaprate;
    private final double[] swapTenor;
    private final ValueUnit valueUnit;

    public SwaptionAnalyticApproximationRebonato(double d, TimeDiscretizationInterface timeDiscretizationInterface) {
        this(d, timeDiscretizationInterface.getAsDoubleArray(), ValueUnit.VALUE);
    }

    public SwaptionAnalyticApproximationRebonato(double d, double[] dArray, ValueUnit valueUnit) {
        this.swaprate = d;
        this.swapTenor = dArray;
        this.valueUnit = valueUnit;
    }

    @Override
    public RandomVariableInterface getValue(double d, LIBORModelMonteCarloSimulationInterface lIBORModelMonteCarloSimulationInterface) {
        return this.getValues(d, lIBORModelMonteCarloSimulationInterface.getModel());
    }

    public RandomVariableInterface getValues(double d, LIBORMarketModelInterface lIBORMarketModelInterface) {
        if (d > 0.0) {
            throw new RuntimeException("Forward start evaluation currently not supported.");
        }
        double d2 = this.swapTenor[0];
        double d3 = this.swapTenor[this.swapTenor.length - 1];
        int n = lIBORMarketModelInterface.getLiborPeriodIndex(d2);
        int n2 = lIBORMarketModelInterface.getLiborPeriodIndex(d3);
        int n3 = lIBORMarketModelInterface.getCovarianceModel().getTimeDiscretization().getTimeIndex(d2) - 1;
        Map<String, double[]> map = SwaptionAnalyticApproximationRebonato.getLogSwaprateDerivative(lIBORMarketModelInterface.getLiborPeriodDiscretization(), lIBORMarketModelInterface.getDiscountCurve(), lIBORMarketModelInterface.getForwardRateCurve(), this.swapTenor);
        double[] dArray = map.get("values");
        double[][] dArray2 = lIBORMarketModelInterface.getIntegratedLIBORCovariance()[n3];
        double d4 = 0.0;
        for (int i = n; i < n2; ++i) {
            for (int j = i + 1; j < n2; ++j) {
                d4 += 2.0 * dArray[i - n] * dArray[j - n] * dArray2[i][j];
            }
            d4 += dArray[i - n] * dArray[i - n] * dArray2[i][i];
        }
        if (this.valueUnit == ValueUnit.INTEGRATEDVARIANCE) {
            return new RandomVariable(d, d4);
        }
        double d5 = Math.sqrt(d4 / d2);
        if (this.valueUnit == ValueUnit.VOLATILITY) {
            return new RandomVariable(d, d5);
        }
        double d6 = Swap.getForwardSwapRate(new TimeDiscretization(this.swapTenor), new TimeDiscretization(this.swapTenor), lIBORMarketModelInterface.getForwardRateCurve(), lIBORMarketModelInterface.getDiscountCurve());
        double d7 = SwapAnnuity.getSwapAnnuity((TimeDiscretizationInterface)new TimeDiscretization(this.swapTenor), lIBORMarketModelInterface.getDiscountCurve());
        double d8 = d2;
        double d9 = AnalyticFormulas.blackModelSwaptionValue(d6, d5, d8, this.swaprate, d7);
        return new RandomVariable(d, d9);
    }

    public static Map<String, double[]> getLogSwaprateDerivative(TimeDiscretizationInterface timeDiscretizationInterface, DiscountCurveInterface discountCurveInterface, ForwardCurveInterface forwardCurveInterface, double[] dArray) {
        int n;
        double d;
        AnalyticModel analyticModel = null;
        if (discountCurveInterface == null) {
            discountCurveInterface = new DiscountCurveFromForwardCurve(forwardCurveInterface.getName());
            analyticModel = new AnalyticModel(new CurveInterface[]{forwardCurveInterface, discountCurveInterface});
        }
        double d2 = dArray[0];
        double d3 = dArray[dArray.length - 1];
        int n2 = timeDiscretizationInterface.getTimeIndex(d2);
        int n3 = timeDiscretizationInterface.getTimeIndex(d3);
        double[] dArray2 = new double[n3 - n2 + 1];
        double[] dArray3 = new double[n3 - n2 + 1];
        dArray3[0] = discountCurveInterface.getDiscountFactor(analyticModel, d2);
        for (int i = n2; i < n3; ++i) {
            dArray2[i - n2] = d = forwardCurveInterface.getForward(null, timeDiscretizationInterface.getTime(i));
            dArray3[i - n2 + 1] = discountCurveInterface.getDiscountFactor(analyticModel, timeDiscretizationInterface.getTime(i + 1));
        }
        double[] dArray4 = new double[dArray.length - 1];
        d = 0.0;
        for (int i = dArray.length - 2; i >= 0; --i) {
            n = timeDiscretizationInterface.getTimeIndex(dArray[i + 1]);
            dArray4[i] = d += dArray3[n - n2] * (dArray[i + 1] - dArray[i]);
        }
        int[] nArray = new int[dArray.length - 1];
        Arrays.fill(nArray, 0);
        int n4 = 0;
        for (n = n2; n < n3; ++n) {
            if (timeDiscretizationInterface.getTime(n) >= dArray[n4 + 1]) {
                // empty if block
            }
            int n5 = ++n4;
            nArray[n5] = nArray[n5] + 1;
        }
        double[] dArray5 = new double[n3 - n2];
        int n6 = 0;
        for (n4 = n2; n4 < n3; ++n4) {
            if (timeDiscretizationInterface.getTime(n4) >= dArray[n6 + 1]) {
                ++n6;
            }
            double d4 = dArray4[n6];
            double d5 = n6 < dArray4.length - 1 ? dArray4[n6 + 1] : 0.0;
            dArray5[n4 - n2] = (d4 - d5) / d / (double)nArray[n6];
        }
        HashMap<String, double[]> hashMap = new HashMap<String, double[]>();
        hashMap.put("values", dArray5);
        hashMap.put("discountFactors", dArray3);
        hashMap.put("swapAnnuities", dArray4);
        return hashMap;
    }

    public static double[][][] getIntegratedLIBORCovariance(LIBORMarketModel lIBORMarketModel) {
        return lIBORMarketModel.getIntegratedLIBORCovariance();
    }

    public static enum ValueUnit {
        VALUE,
        INTEGRATEDVARIANCE,
        VOLATILITY;

    }
}

