/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products;

import java.util.Arrays;
import net.finmath.exception.CalculationException;
import net.finmath.functions.AnalyticFormulas;
import net.finmath.marketdata.model.curves.ForwardCurveInterface;
import net.finmath.marketdata.products.Swap;
import net.finmath.marketdata.products.SwapAnnuity;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.interestrate.products.AbstractLIBORMonteCarloProduct;
import net.finmath.stochastic.RandomVariableInterface;
import net.finmath.time.TimeDiscretization;
import net.finmath.time.TimeDiscretizationInterface;

public class Swaption
extends AbstractLIBORMonteCarloProduct {
    private double exerciseDate;
    private double[] fixingDates;
    private double[] paymentDates;
    private double[] periodLengths;
    private double[] swaprates;

    public Swaption(double d, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        this.exerciseDate = d;
        this.fixingDates = dArray;
        this.paymentDates = dArray2;
        this.periodLengths = dArray3;
        this.swaprates = dArray4;
    }

    public Swaption(double d, double[] dArray, double[] dArray2, double[] dArray3) {
        this.exerciseDate = d;
        this.fixingDates = dArray;
        this.paymentDates = dArray2;
        this.periodLengths = null;
        this.swaprates = dArray3;
    }

    public Swaption(double d, TimeDiscretizationInterface timeDiscretizationInterface, double d2) {
        this.exerciseDate = d;
        this.fixingDates = new double[timeDiscretizationInterface.getNumberOfTimeSteps()];
        this.paymentDates = new double[timeDiscretizationInterface.getNumberOfTimeSteps()];
        for (int i = 0; i < this.fixingDates.length; ++i) {
            this.fixingDates[i] = timeDiscretizationInterface.getTime(i);
            this.paymentDates[i] = timeDiscretizationInterface.getTime(i + 1);
        }
        this.periodLengths = null;
        this.swaprates = new double[timeDiscretizationInterface.getNumberOfTimeSteps()];
        Arrays.fill(this.swaprates, d2);
    }

    @Override
    public RandomVariableInterface getValue(double d, LIBORModelMonteCarloSimulationInterface lIBORModelMonteCarloSimulationInterface) throws CalculationException {
        double d2;
        RandomVariableInterface randomVariableInterface = lIBORModelMonteCarloSimulationInterface.getRandomVariableForConstant(0.0);
        for (int i = this.fixingDates.length - 1; i >= 0; --i) {
            d2 = this.fixingDates[i];
            double d3 = this.paymentDates[i];
            double d4 = this.swaprates[i];
            double d5 = this.periodLengths != null ? this.periodLengths[i] : d3 - d2;
            RandomVariableInterface randomVariableInterface2 = lIBORModelMonteCarloSimulationInterface.getLIBOR(this.exerciseDate, d2, d3);
            RandomVariableInterface randomVariableInterface3 = randomVariableInterface2.sub(d4).mult(d5);
            randomVariableInterface = randomVariableInterface.add(randomVariableInterface3);
            randomVariableInterface = randomVariableInterface.discount(randomVariableInterface2, d3 - d2);
        }
        if (this.fixingDates[0] != this.exerciseDate) {
            RandomVariableInterface randomVariableInterface4 = lIBORModelMonteCarloSimulationInterface.getLIBOR(this.exerciseDate, this.exerciseDate, this.fixingDates[0]);
            d2 = this.fixingDates[0] - this.exerciseDate;
            randomVariableInterface = randomVariableInterface.discount(randomVariableInterface4, d2);
        }
        RandomVariableInterface randomVariableInterface5 = randomVariableInterface.floor(0.0);
        RandomVariableInterface randomVariableInterface6 = lIBORModelMonteCarloSimulationInterface.getNumeraire(this.exerciseDate);
        RandomVariableInterface randomVariableInterface7 = lIBORModelMonteCarloSimulationInterface.getMonteCarloWeights(lIBORModelMonteCarloSimulationInterface.getTimeIndex(this.exerciseDate));
        randomVariableInterface5 = randomVariableInterface5.div(randomVariableInterface6).mult(randomVariableInterface7);
        RandomVariableInterface randomVariableInterface8 = lIBORModelMonteCarloSimulationInterface.getNumeraire(d);
        RandomVariableInterface randomVariableInterface9 = lIBORModelMonteCarloSimulationInterface.getMonteCarloWeights(d);
        randomVariableInterface5 = randomVariableInterface5.mult(randomVariableInterface8).div(randomVariableInterface9);
        return randomVariableInterface5;
    }

    public double getValue(ForwardCurveInterface forwardCurveInterface, double d) {
        double d22;
        double d3 = this.swaprates[0];
        for (double d22 : this.swaprates) {
            if (d22 == d3) continue;
            throw new RuntimeException("Uneven swaprates not allows for analytical pricing.");
        }
        double[] dArray = new double[this.fixingDates.length + 1];
        System.arraycopy(this.fixingDates, 0, dArray, 0, this.fixingDates.length);
        dArray[dArray.length - 1] = this.paymentDates[this.paymentDates.length - 1];
        double d4 = Swap.getForwardSwapRate(new TimeDiscretization(dArray), new TimeDiscretization(dArray), forwardCurveInterface);
        d22 = SwapAnnuity.getSwapAnnuity((TimeDiscretizationInterface)new TimeDiscretization(dArray), forwardCurveInterface);
        return AnalyticFormulas.blackModelSwaptionValue(d4, d, this.exerciseDate, d3, d22);
    }

    @Override
    public String toString() {
        return super.toString() + "\n" + "exerciseDate: " + this.exerciseDate + "\n" + "fixingDates: " + Arrays.toString(this.fixingDates) + "\n" + "paymentDates: " + Arrays.toString(this.paymentDates) + "\n" + "periodLengths: " + Arrays.toString(this.periodLengths) + "\n" + "swaprates: " + Arrays.toString(this.swaprates);
    }
}

