/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products;

import java.util.Arrays;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.interestrate.products.AbstractLIBORMonteCarloProduct;
import net.finmath.stochastic.RandomVariableInterface;

public class SimpleSwap
extends AbstractLIBORMonteCarloProduct {
    private double[] fixingDates;
    private double[] paymentDates;
    private double[] swaprates;

    public SimpleSwap(double[] dArray, double[] dArray2, double[] dArray3) {
        this.fixingDates = dArray;
        this.paymentDates = dArray2;
        this.swaprates = dArray3;
    }

    @Override
    public RandomVariableInterface getValue(double d, LIBORModelMonteCarloSimulationInterface lIBORModelMonteCarloSimulationInterface) throws CalculationException {
        RandomVariableInterface randomVariableInterface = lIBORModelMonteCarloSimulationInterface.getRandomVariableForConstant(0.0);
        for (int i = 0; i < this.fixingDates.length; ++i) {
            double d2 = this.fixingDates[i];
            double d3 = this.paymentDates[i];
            double d4 = this.swaprates[i];
            double d5 = d3 - d2;
            if (d3 < d) continue;
            RandomVariableInterface randomVariableInterface2 = lIBORModelMonteCarloSimulationInterface.getLIBOR(d2, d2, d3);
            RandomVariableInterface randomVariableInterface3 = randomVariableInterface2.sub(d4).mult(d5);
            RandomVariableInterface randomVariableInterface4 = lIBORModelMonteCarloSimulationInterface.getNumeraire(d3);
            RandomVariableInterface randomVariableInterface5 = lIBORModelMonteCarloSimulationInterface.getMonteCarloWeights(lIBORModelMonteCarloSimulationInterface.getTimeIndex(d3));
            randomVariableInterface3 = randomVariableInterface3.div(randomVariableInterface4).mult(randomVariableInterface5);
            randomVariableInterface = randomVariableInterface.add(randomVariableInterface3);
        }
        RandomVariableInterface randomVariableInterface6 = lIBORModelMonteCarloSimulationInterface.getNumeraire(d);
        RandomVariableInterface randomVariableInterface7 = lIBORModelMonteCarloSimulationInterface.getMonteCarloWeights(d);
        randomVariableInterface = randomVariableInterface.mult(randomVariableInterface6).div(randomVariableInterface7);
        return randomVariableInterface;
    }

    @Override
    public String toString() {
        return super.toString() + "\n" + "fixingDates: " + Arrays.toString(this.fixingDates) + "\n" + "paymentDates: " + Arrays.toString(this.paymentDates) + "\n" + "swaprates: " + Arrays.toString(this.swaprates);
    }
}

